ORCA/M Asm65816 2.1.0

0001 9A00                       print nohdr,nomdir,nogen
0002 9A00                       pagesize 70 
0003 9A00                       string asis
0004 9A00
0005 9A00              do_force_lock equ   1                   ;set to 0 to skip the calls that lock and unlock
0006 9A00                                                      ; all of GS/OS-managed memory on each and every
0007 9A00                                                      ; GS/OS call.
0008 9A00
0009 9A00              *******************************************************************************
0010 9A00              *
0011 9A00              * GS/OS System Call Manager ("SCuM")
0012 9A00              *
0013 9A00              * Authors:
0014 9A00              *
0015 9A00              *       Mike Askins     Jan, 1987 - Oct, 1988
0016 9A00              *       Jim Jatczynski  Jan, 1987 - Oct, 1988
0017 9A00              *       Bryan Atsatt    Oct, 1988 - Sep, 1989
0018 9A00              *       Cary Farrier    Sep, 1989 - Dec, 1990
0019 9A00              *       Greg Branche    Jan, 1991 - Feb, 1992
0020 9A00              *       Dave Lyons/Greg July, 1992 - Present
0021 9A00              *
0022 9A00              *       a.k.a. "SCuM Lords"
0023 9A00              *
0024 9A00              * Copyright (c) 1987-93 Apple Computer, Inc.  All Rights Reserved
0025 9A00              *******************************************************************************
0026 9A00                       eject 
0027 9A00              ******************************************************************************
0028 9A00              *                                                                            *
0029 9A00              *                  System Call Manager Modification History                  *
0030 9A00              *                                                                            *
0031 9A00              *                                                                            *
0032 9A00              * Date          Ver     Who     Description                                  *
0033 9A00              * -------------------------------------------------------------------------- *
0034 9A00              * 18 Dec 87 - 06/20/90  See an archived version of this file.  I don't see any
0035 9A00              *                       point in wasting all the space for a history lesson.
0036 9A00              *                       I've picked up the revision history after System Disk
0037 9A00              *                       5.0.4 was frozen. (Greg Branche)
0038 9A00              *
0039 9A00              * 09/25/90              CAF     Uncommented all the console speedup routines, 
0040 9A00              *                               now character output is about 28% faster, but
0041 9A00              *                               could use some more work particularly in the
0042 9A00              *                               find_fcr area.  Optimized some code in
0043 9A00              *                               os_shutdown to free up more space, as marked
0044 9A00              *                               by {CAF}.
0045 9A00              *
0046 9A00              * 01/24/91      3.07(?) GAB     Removed all code that maintained the unclaimed
0047 9A00              *                                 interrupt counter.
0048 9A00              *                               Added support for JudgeName.
0049 9A00              *
0050 9A00              * 02/12/91      4.00d1  GAB     Reworked do_type_7 procedure to support the
0051 9A00              *                                 new Init Manager code.
0052 9A00              *
0053 9A00              * 02/21/91      4.00d2  GAB     Implemented enhanced Volume call.
0054 9A00              *                               Shrunk the GetFSTInfo call a little, and changed
0055 9A00              *                                 the result buffer pointer check so that a NULL
0056 9A00              *                                 pointer is allowed.  Previously, a NULL pointer
0057 9A00              *                                 would produce a param_range_error.
0058 9A00              *                               Checked remaining calls that include a GS/OS result
0059 9A00              *                                 buffer parameter, and they all now allow a NULL
0060 9A00              *                                 pointer.
0061 9A00              *
0062 9A00              * 02/27/91      4.00d3  GAB     Implemented enhanced GetRefInfo call.
0063 9A00              *                               Cleaned up do_type_7 so that the caller's parameter
0064 9A00              *                                 block is no longer altered.  Since the FST's
0065 9A00              *                                 now accept any pCount from 1-6, and they use
0066 9A00              *                                 the name pointed to by path2_ptr, the parmBlock
0067 9A00              *                                 doesn't need to be modified.
0068 9A00              *
0069 9A00              * 03/07/91      4.00d4  GAB     $E1 segment now starts at address $E1DA00 instead of
0070 9A00              *                                 $E1DC00.
0071 9A00              *                               When GS/OS displays the dialog asking the user to
0072 9A00              *                                 insert a disk, it will now continually scan all
0073 9A00              *                                 online block devices that contain removeable media
0074 9A00              *                                 (except for Disk ]['s) looking for a disk insertion
0075 9A00              *                                 event.  When GS/OS recognizes that a disk is inserted,
0076 9A00              *                                 the dialog will go away as if the user pressed the
0077 9A00              *                                 Return key to accept the default selection.  (This is
0078 9A00              *                                 actually implemented as a new System Service Call,
0079 9A00              *                                 which AlertWindow calls as part of its event loop.) In
0080 9A00              *                                 addition, SysBeep2 is also called with a beep code
0081 9A00              *                                 of $C030 (disk request, silent by default, activated
0082 9A00              *                                 on next call to GetNextEvent).
0083 9A00              *                               When processing calls to FSTs that contain a pathname
0084 9A00              *                                 parameter (the infamous "bouncing" process), SCM now
0085 9A00              *                                 post-processes the error code returned by the FST in
0086 9A00              *                                 an attempt to prioritize the error.  See the GS/OS
0087 9A00              *                                 Delta ERS for details.
0088 9A00              *                               When processing a pathname that starts with a digit,
0089 9A00              *                                 GS/OS now attempts to determine whether the leading
0090 9A00              *                                 number is a prefix or not.  If it decides that the
0091 9A00              *                                 number is NOT a prefix, it processes the pathname
0092 9A00              *                                 using the default prefix instead of setting the
0093 9A00              *                                 prefix number to the supplied prefix.  This means
0094 9A00              *                                 that you can now specify filenames such as
0095 9A00              *                                 "6.0 Systems" without having to build a full
0096 9A00              *                                 pathname first.
0097 9A00              *
0098 9A00              * 03/11/91      4.00d5  GAB     OSShutdown call now supports automatically ejecting
0099 9A00              *                                 disks.  If the call is a full shutdown call (not
0100 9A00              *                                 a restart call), or if it is a restart call and
0101 9A00              *                                 bit 2 of the flags is also set, the device
0102 9A00              *                                 dispatcher is called with a command code of 3
0103 9A00              *                                 (full shutdown) instead of 2 (normal shutdown).
0104 9A00              *
0105 9A00              * 04/24/91      4.00d6  GAB     OSShutdown fixed so that it does not eject disks
0106 9A00              *                                 during a restart call.
0107 9A00              *                               SysBeep2 changed to SysBeep in getkey procedure,
0108 9A00              *                                 since we're not guaranteed that SysBeep2 exists
0109 9A00              *                                 at the time that it's called (i.e. during booting).
0110 9A00              *
0111 9A00              * 05/09/91      4.00d7  GAB     Volume call enhanced so that if a duplicate volume
0112 9A00              *                                 error is returned from an FST, and the pCount is 7
0113 9A00              *                                 or greater, SCM will fill the caller's parameter
0114 9A00              *                                 block in with the FST ID of the FST that is
0115 9A00              *                                 returning the error, as well as the characteristics
0116 9A00              *                                 parameter.  The device ID parameter is also
0117 9A00              *                                 returned.
0118 9A00              *                               do_type_7 now checks the reqFileSysID parameter to
0119 9A00              *                                 ensure that it refers to an FST that supports
0120 9A00              *                                 formatting prior to calling the Format Manager.
0121 9A00              *
0122 9A00              * 05/21/91      4.00d8  GAB     do_type_7 now returns error code $65 when a
0123 9A00              *                                 reqFileSysID specifies an FST that is installed
0124 9A00              *                                 in the system but that does not support formatting.
0125 9A00              *
0126 9A00              * 05/28/91      4.00d9  GAB     do_type_7 defers judgement to the Init Manager on
0127 9A00              *                                 whether or not the reqFileSysID parameter is
0128 9A00              *                                 valid.  This reverses the change made in d7.
0129 9A00              *
0130 9A00              * 06/07/91      4.00d10 GAB     Main call dispatcher now performs the character FST
0131 9A00              *                                 write check inline, instead of as a subroutine
0132 9A00              *                                 call.
0133 9A00              *                               Device manager calls are special cased like the
0134 9A00              *                                 Character FST Write calls.
0135 9A00              *                               Modified GIM NewHandle call to allocate a new block
0136 9A00              *                                 as locked if the lock_mem call count is non-zero
0137 9A00              *                                 (i.e. if the rest of GIM memory is already locked)
0138 9A00              *
0139 9A00              * 06/19/91      4.00d11 GAB     Move force_lock and force_unlock from main call
0140 9A00              *                                 dispatcher to FST call dispatcher.
0141 9A00              *                               Set bit 5 of AlertWindow flags so that any
0142 9A00              *                                 buttons displayed in the window are located
0143 9A00              *                                 as suggested by HIG.
0144 9A00              *
0145 9A00              * 07/24/91      4.00d12 GAB     Changed SysBeep2 flags so that the beep is NOT
0146 9A00              *                                 silent by default.
0147 9A00              *
0148 9A00              * 07/31/91      4.00d13 GAB     Changed do_type_7 so that bit 13 of the call's
0149 9A00              *                                 'flags' parameter is allowed.  Setting this
0150 9A00              *                                 bit in a Format call will inhibit the display
0151 9A00              *                                 of the 'Initializing' information dialog.
0152 9A00              *
0153 9A00              * 08/16/91      4.00d14 GAB     Changed volume call so that bit 4 of the returned
0154 9A00              *                                 characteristics parameter will be set if the
0155 9A00              *                                 volume in question contains any open files.
0156 9A00              *
0157 9A00              * 08/31/91      4.00d15 GAB     Changed do_force_unlock flag so that the calls to
0158 9A00              *                                 force_lock and force_unlock are back where they
0159 9A00              *                                 originally were (within the main call dispatcher)
0160 9A00              *                                 instead of within the Call_FST subroutine.  I
0161 9A00              *                                 forgot that the "speeded-up" calls to the
0162 9A00              *                                 Character FST also go through the Call_FST
0163 9A00              *                                 subroutine, which means that when I added the
0164 9A00              *                                 force_lock and force_unlock around the actual
0165 9A00              *                                 FST call, I slowed down the baud rate again.
0166 9A00              *                               Added logic to call processing to speed up
0167 9A00              *                                 character I/O by not calling inc_busy_flag &
0168 9A00              *                                 dec_busy_flag when the character FST is called.
0169 9A00              *                                 Duplicates functionality of QuickConsole INIT.
0170 9A00              *                               Fixed get_ref_num to work properly if one of the
0171 9A00              *                                 standard I/O prefixes is specified (10, 11,
0172 9A00              *                                 or 12) when the prefix contains a device
0173 9A00              *                                 name.
0174 9A00              *                               Changed do_type_2 so that if a file_busy error
0175 9A00              *                                 is returned from the FST, SCM will see if the
0176 9A00              *                                 caller was attempting to open prefix 11 or
0177 9A00              *                                 prefix 12 (stdout or stderr). If so, SCM then
0178 9A00              *                                 checks the pCount, which must be less than 4 (
0179 9A00              *                                 since it can't return all of the file information
0180 9A00              *                                 described by the remaining parameters).  If the
0181 9A00              *                                 pCount is within range, the system will then
0182 9A00              *                                 compare the contents of the two prefixes.  If
0183 9A00              *                                 the prefixes are identical (except for character
0184 9A00              *                                 case), GS/OS will return the same refnum as
0185 9A00              *                                 used for the alternate i/o stream (e.g. if
0186 9A00              *                                 prefix 12 is being opened, but the physical
0187 9A00              *                                 file has already been opened as prefix 11,
0188 9A00              *                                 GS/OS will duplicate the stdout prefix for
0189 9A00              *                                 stderr).  This was done to better support
0190 9A00              *                                 i/o redirection.
0191 9A00              *                               Changed do_type_3 so that if a close call is
0192 9A00              *                                 being made with a refnum that applies to BOTH
0193 9A00              *                                 stdout and stderr, the call completes without
0194 9A00              *                                 error, but the file is not actually closed.  In
0195 9A00              *                                 this case, the stderr stream will be the first
0196 9A00              *                                 one logically closed (it's internal refnum is
0197 9A00              *                                 zeroed).
0198 9A00              *                               Added SetStdRefNum call to allow an application
0199 9A00              *                                 (like ORCA) to specifically set the refnum
0200 9A00              *                                 associated with one of the standard i/o
0201 9A00              *                                 prefixes.  Parameter block is identical
0202 9A00              *                                 to GetStdRefNum.  The refnum supplied must
0203 9A00              *                                 refer to a currently open file.
0204 9A00              *                               Bug fix in e1_volume_call.  No longer attempts
0205 9A00              *                                 to return the "open_files" bit of the charac-
0206 9A00              *                                 teristics word if an error is reported by the
0207 9A00              *                                 called FST.
0208 9A00              *                               Had to shuffle some subroutines around from
0209 9A00              *                                 segment to segment to get all of the above
0210 9A00              *                                 to fit.
0211 9A00              *
0212 9A00              * 09/05/91      4.00d16 GAB     In return_from_lc, checking the state of bit 14
0213 9A00              *                                 of io_flag prior to calling the signal dispatcher
0214 9A00              *                                 was not working properly.  It should now.
0215 9A00              *
0216 9A00              * 10/10/91      4.00d17 GAB     do_insert_scan modified to skip the status call
0217 9A00              *                                 on an Apple SCSI tape drive.
0218 9A00              *
0219 9A00              * 10/30/91      4.00d18 GAB     e1_volume_call modified to use the device number
0220 9A00              *                                 stored in dev_num ($36) instead of whatever
0221 9A00              *                                 is left over in drvr_dev_num ($00).
0222 9A00              *
0223 9A00              * 11/07/91      4.00d19 GAB     new_volume_call modified to zero the string
0224 9A00              *                                 length word in the volume name result buffer
0225 9A00              *                                 prior to calling the FSTs.
0226 9A00              *                               release_v_ptrs optimized.
0227 9A00              *
0228 9A00              * 11/13/91      4.00d20 GAB     new_volume_call reverted back to its original,
0229 9A00              *                                 pre-4.0d19 form.  Applications are allowed to
0230 9A00              *                                 use the same buffer for both input and output
0231 9A00              *                                 strings for the Volume call.  If SCM zeros
0232 9A00              *                                 the length word, it's actually zeroing the
0233 9A00              *                                 length word of the input pathname.
0234 9A00              *                               Removed code that set 'shutdown_flag', since
0235 9A00              *                                 no one ever reads the value that's stored there.
0236 9A00              *
0237 9A00              * 12/05/91      4.00d21 GAB     Altered call_fsts to handle the new flags parameter
0238 9A00              *                                 to the ChangePath call.  If bit 15 of the flags
0239 9A00              *                                 word is set AND pathname 1 consists of ONLY a
0240 9A00              *                                 device name (i.e. the volume name is being changed),
0241 9A00              *                                 the Loader_Rename call is skipped.
0242 9A00              *
0243 9A00              * 12/07/91      4.00d22 GAB     Remove 'and #$00FF' from s_sys_death.  It shouldn't be
0244 9A00              *                                 altering the error code in the first place.
0245 9A00              *                               Add support in set_prefix and get_prefix to allow caller
0246 9A00              *                                 to set and retrieve the '@' prefix.  This is done
0247 9A00              *                                 by specifying a prefix number of $FFFF (-1) in the
0248 9A00              *                                 SetPrefix and GetPrefix parameter blocks.
0249 9A00              *
0250 9A00              * 01/06/92      4.00d23 GAB     In call_fsts, if an FST returns an error code with the
0251 9A00              *                                 priority bit set (bit 15), SCM will exit the subroutine
0252 9A00              *                                 immediately.  Having the priority bit set means that the
0253 9A00              *                                 FST is claiming that the call belonged to it.  Therefore
0254 9A00              *                                 there's no reason to continue the call loop and allow
0255 9A00              *                                 the remaining FSTs to encounter an error which won't
0256 9A00              *                                 be reported to the caller (since the error with the
0257 9A00              *                                 priority bit set will be the one returned in any case).
0258 9A00              *                               os_shutdown now initializes sys_prefs to 0 prior to
0259 9A00              *                                 displaying the shutdown dialog to ensure that the dialog
0260 9A00              *                                 is actually displayed.
0261 9A00              *
0262 9A00              * 01/18/92      4.00d24 GAB     Moved e1_get_ref_info back into bank 0 (since optimizing
0263 9A00              *                                 release_v_ptrs freed up enough room for it) and removed
0264 9A00              *                                 it from bank $E1.
0265 9A00              *                               Moved init_fst_tbl into miscellaneous segment to free up
0266 9A00              *                                 some room in the bank $E1 segment.  Also rewrote routine
0267 9A00              *                                 to be more memory efficient.
0268 9A00              *                               $E1 segment now starts at $E1D980 to make room for
0269 9A00              *                                 the following fix.
0270 9A00              *                               Loader_Rename now scans through all active FCRs to see
0271 9A00              *                                 if any portion of an open file's pathname is being
0272 9A00              *                                 changed.  If so, the name stored with the FCR is
0273 9A00              *                                 changed to reflect the new pathname.
0274 9A00              *
0275 9A00              * 01/23/92      4.00d25 GAB     When the original pathname was specified as ONLY
0276 9A00              *                                 a device name for a ChangePath call, meaning that
0277 9A00              *                                 the volume name was being changed, the
0278 9A00              *                                 insert_vol_name call within Loader_Rename was
0279 9A00              *                                 occurring AFTER the volume name had already been
0280 9A00              *                                 changed by the FST.  This means that the original
0281 9A00              *                                 pathname had the _new_ volume name used instead
0282 9A00              *                                 of the actual original volume name.  I've added
0283 9A00              *                                 the rename_preamble routine that is used by
0284 9A00              *                                 call_fsts PRIOR to calling the FST so that the
0285 9A00              *                                 REAL original volume name can be determined.
0286 9A00              *
0287 9A00              * 02/10/92      4.00d26 GAB     Fixed bug in xlate_path which was allowing a 0-length
0288 9A00              *                                 pathname to be accepted without generating a
0289 9A00              *                                 bad_path_syntax error.  When I optimized the
0290 9A00              *                                 call in the last version, I missed changing
0291 9A00              *                                 the BNE at is_null into a BEQ to syntax_err.
0292 9A00              *
0293 9A00              *******************************************************************************
0294 9A00              *
0295 9A00              * Begin 6.0.1
0296 9A00              *
0297 9A00              * 17-Jul-92     4.02d8 DAL      Changed restart_system to store a little piece
0298 9A00              *                                 of code at $F0 instead of $0300 (it bugged me
0299 9A00              *                                 to have it trash $0300).
0300 9A00              *                               Changed which_one to force screen dimmers to
0301 9A00              *                                 un-dim before choosing whehter to use the
0302 9A00              *                                 Super Hi-Res screen or not.  Reorganized code
0303 9A00              *                                 to come close to breaking even in bytes.
0304 9A00              *                               Minor optimizations to save enough bytes for the
0305 9A00              *                                 above changes.
0306 9A00              *
0307 9A00              * 20-Jul-92     DAL             Changed the above SendRequest in which_one to
0308 9A00              *                                 clean up the stack on a dispatcher error,
0309 9A00              *                                 since this can get used during boot before
0310 9A00              *                                 the toolbox is patched (before SendRequest
0311 9A00              *                                 actually exists!).
0312 9A00              *
0313 9A00              * 12-Aug-92     DAL             Changed SysBeep2 call in s_mount_msg to clean up
0314 9A00              *                                 stack on error (in case Tool.Setup isn't loaded
0315 9A00              *                                 yet).
0316 9A00              *
0317 9A00              * 20-Aug-92     DAL             Added $01FCE0 s_toolbox_msg, new entry point to
0318 9A00              *                                 the s_full_error routine for AlertMessage to
0319 9A00              *                                 call from the Misc Tools.  Random optimizations
0320 9A00              *                                 to save enough bytes to fit in the above.
0321 9A00              *
0322 9A00              * 2-Sep-92      DAL             Made two changes to OSShutDown:
0323 9A00              *                                 •It was accidentally skipping the DeskShutDown
0324 9A00              *                                 call if flag bit 2 was clear.
0325 9A00              *                                 •It wasn't calling os_p8_switch to tell DoRight
0326 9A00              *                                 that GS/OS was going away.
0327 9A00              *
0328 9A00              * 15-Dec-92     DAL             Two changes disp_common_int:
0329 9A00              *                                 •Returns CLC if and only if at least one interrupt
0330 9A00              *                                  handler claimed the interrupt (was previously
0331 9A00              *                                  clearing carry when the *last* handler claimed it).
0332 9A00              *                                 •Restores MSLOT after dispatching to an IRQ.OTHER
0333 9A00              *                                  handler.
0334 9A00              *                                 •Lots of optimizations to make room for the above,
0335 9A00              *                                  including removing a redundant check in create_seg
0336 9A00              *                                  to see if we need to lock a newly-created handle.
0337 9A00              *
0338 9A00              * 2-Mar-93      DAL             Added code to put a $4C at $BF00 at the beginning of
0339 9A00              *                                 every GS/OS call, so the Vulcan without a loaded
0340 9A00              *                                 driver will be happy.  Steve Stephenson and I spent
0341 9A00              *                                 long enough investigating this that we fixed it even
0342 9A00              *                                 though it is stupid (Vulcan should not be looking
0343 9A00              *                                 at $BF00 after boot).
0344 9A00              *                               For debugging convenience, on the way out of a GS/OS
0345 9A00              *                                 call we store any nonzero error code at $FC/4242.
0346 9A00              *
0347 9A00              * 9-Mar-93      DAL             Added code in OSShutDown to call os_p8_switch with
0348 9A00              *                                 A = $8000, so the Ethernet card can cleanly shut
0349 9A00              *                                 down and revert to its original $Cn00 state.
0350 9A00              *
0351 9A00              *******************************************************************************
0352 9A00
0353 9A00                       print push
0354 9A00                       print off
0355 9A00                       eject 
0356 9A00              *******************************************************************************
0357 9A00              *
0358 9A00              *   Imported Addresses
0359 9A00              *
0360 9A00              *******************************************************************************
0361 9A00
0362 9A00                       import cash_add
0363 9A00                       import cash_del_vol
0364 9A00                       import cash_delete
0365 9A00                       import cash_find
0366 9A00                       import cash_flsh_def
0367 9A00                       import cash_init
0368 9A00                       import cash_shutdown
0369 9A00                       import dev_dispatch
0370 9A00                       import e1_app_filename
0371 9A00                       import e1_msg_address
0372 9A00                       import e1_volname
0373 9A00                       import eq_msg_address
0374 9A00                       import g_dispatch
0375 9A00                       import get_b0_buff
0376 9A00                       import get_dnum
0377 9A00                       import get_stacked_id
0378 9A00                       import init_pack
0379 9A00                       import lc_dispatcher
0380 9A00                       import p16quit
0381 9A00                       import post_driver
0382 9A00                       import rename_bootvol
0383 9A00                       import set_disk_sw
0384 9A00                       import set_gsos_speed
0385 9A00                       import slot_arbiter
0386 9A00                       import supervisory
0387 9A00                       import to_bank0_core
0388 9A00
0389 9A00                       import insert_driver
0390 9A00                       import init_pack_end
0391 9A00                       import e1_gsos_ok
0392 9A00
0393 9A00                       eject 
0394 9A00              *******************************************************************************
0395 9A00              *
0396 9A00              * Exported addresses
0397 9A00              *
0398 9A00              *******************************************************************************
0399 9A00
0400 9A00                       export s_flags:equ
0401 9A00                       export entry_size:equ
0402 9A00                       export id:equ
0403 9A00                       export alert_ptr:equ
0404 9A00                       export subst_ptr:equ
0405 9A00
0406 9A00                       export add_fst
0407 9A00                       export deallocate
0408 9A00                       export event_queue
0409 9A00                       export fst_count
0410 9A00                       export fst_tbl
0411 9A00                       export gsos_id
0412 9A00                       export init_scm
0413 9A00                       export os_event
0414 9A00                       export restart_system
0415 9A00                       export set_prefix_33
0416 9A00                       export shutdown_scm
0417 9A00                       export close_all_files
0418 9A00                       export v_ptr1
0419 9A00                       export v_ptr2
0420 9A00
0421 9A00                       eject 
0422 9A00              *******************************************************************************
0423 9A00              *
0424 9A00              *   Forward addresses
0425 9A00              *
0426 9A00              *******************************************************************************
0427 9A00
0428 9A00                       entry add_element
0429 9A00                       entry alloc_int
0430 9A00                       entry alloc_record
0431 9A00                       entry alloc_string
0432 9A00                       entry alloc_zero
0433 9A00                       entry allocate
0434 9A00                       entry allocfcr
0435 9A00                       entry allocvcr
0436 9A00                       entry altcharsv
0437 9A00                       entry begin_session
0438 9A00                       entry bind_int
0439 9A00                       entry build_icr
0440 9A00                       entry cab_2
0441 9A00                       entry calc_span
0442 9A00                       entry call_fsts
0443 9A00                       entry call_fst
0444 9A00                       entry case_mask
0445 9A00                       entry char_index
0446 9A00                       entry check_call
0447 9A00                       entry chk_app_buf
0448 9A00                       entry class
0449 9A00                       entry classify_char
0450 9A00                       entry col80sv
0451 9A00                       entry common_disp_jmp
0452 9A00                       entry common_int_ent
0453 9A00                       entry copy_ext_string
0454 9A00                       entry copy_gstring
0455 9A00                       entry copy_xlate
0456 9A00                       entry create_seg
0457 9A00                       entry ctype_vector
0458 9A00                       entry curr_fst
0459 9A00                       entry cvt0to1
0460 9A00                       entry cvt1to0
0461 9A00                       entry cvt_normal_exit
0462 9A00                       entry dealloc_int
0463 9A00                       entry deallocate
0464 9A00                       entry death_sub_tbl
0465 9A00                       entry default_b_data
0466 9A00                       entry dequeue_signal
0467 9A00                       entry deref2
0468 9A00                       entry deref2_vp
0469 9A00                       entry deref_int
0470 9A00                       entry interrupt_state
0471 9A00                       entry disp_stub_1
0472 9A00                       entry disp_stub_2
0473 9A00                       entry dispatch_busy
0474 9A00                       entry do_button
0475 9A00                       entry do_fst
0476 9A00                       entry do_get_last_dev
0477 9A00                       entry do_judgename
0478 9A00                       entry do_quit
0479 9A00                       entry do_type_0
0480 9A00                       entry do_type_1
0481 9A00                       entry do_type_2
0482 9A00                       entry do_type_3
0483 9A00                       entry do_type_4
0484 9A00                       entry do_type_5
0485 9A00                       entry do_type_6
0486 9A00                       entry do_type_7
0487 9A00                       entry domvxonstack
0488 9A00                       entry draw_box
0489 9A00                       entry empty_vect
0490 9A00                       entry end_session
0491 9A00                       entry entry_mode
0492 9A00                       entry entry_point
0493 9A00                       entry entry_type
0494 9A00                       entry event_code
0495 9A00                       entry event_flags
0496 9A00                       entry event_queue
0497 9A00                       entry expand_path
0498 9A00                       entry fatal_err_num
0499 9A00                       entry fatal_err_str
0500 9A00                       entry fcr_id_hand
0501 9A00                       entry fe_xlate
0502 9A00                       entry find_fst
0503 9A00                       entry find_record
0504 9A00                       entry findfcr
0505 9A00                       entry findvcr
0506 9A00                       entry findvcrcase
0507 9A00                       entry free
0508 9A00                       entry free_id
0509 9A00                       entry free_mm_seg
0510 9A00                       entry fst_count
0511 9A00                       entry fst_entry_size
0512 9A00                       entry fst_flags
0513 9A00                       entry fst_spec
0514 9A00                       entry fst_tbl
0515 9A00                       entry gbuf
0516 9A00                       entry gderef
0517 9A00                       entry get_boot_vol
0518 9A00                       entry get_fst_info
0519 9A00                       entry get_level
0520 9A00                       entry get_level_flag
0521 9A00                       entry get_mm_id
0522 9A00                       entry get_name
0523 9A00                       entry get_pfx
0524 9A00                       entry get_prefix
0525 9A00                       entry get_record
0526 9A00                       entry get_sys_prefs
0527 9A00                       entry get_version
0528 9A00                       entry getfcr
0529 9A00                       entry getkey
0530 9A00                       entry getvcr
0531 9A00                       entry gotoxy
0532 9A00                       entry gprex_alt_ent
0533 9A00                       entry grab_mm_seg
0534 9A00                       entry grow_list
0535 9A00                       entry gs_move_info
0536 9A00                       entry gsos_id
0537 9A00                       entry handled
0538 9A00                       entry icr_id_hand
0539 9A00                       entry init_fst_tbl
0540 9A00                       entry init_gim
0541 9A00                       entry init_int
0542 9A00                       entry init_list
0543 9A00                       entry init_signal
0544 9A00                       entry inline_entry
0545 9A00                       entry int_disp_jump
0546 9A00                       entry inverse
0547 9A00                       entry is_bouncer
0548 9A00                       entry is_volume_only
0549 9A00                       entry jump_v
0550 9A00                       entry kill_element
0551 9A00                       entry last_fst
0552 9A00                       entry lcbank1_twice            ;2-Mar-93 DAL
0553 9A00                       entry lc_inline_entry
0554 9A00                       entry lc_stack_entry
0555 9A00                       entry lc_state
0556 9A00                       entry ldxy_idhand
0557 9A00                       entry len_to_delim
0558 9A00                       entry link_record
0559 9A00                       entry list_index
0560 9A00                       entry loc_1
0561 9A00                       entry loc_2
0562 9A00                       entry lock_flag
0563 9A00                       entry lock_hand
0564 9A00                       entry lockmem
0565 9A00                       entry look_at_char
0566 9A00                       entry loop45
0567 9A00                       entry low_allocate
0568 9A00                       entry m_abortmove
0569 9A00                       entry m_contdomove
0570 9A00                       entry m_movefinished
0571 9A00                       entry m_scon_dcon
0572 9A00                       entry m_scon_ddec
0573 9A00                       entry m_scon_dinc
0574 9A00                       entry m_sdec_dcon
0575 9A00                       entry m_sdec_ddec
0576 9A00                       entry m_sdec_dinc
0577 9A00                       entry m_sinc_dcon
0578 9A00                       entry m_sinc_ddec
0579 9A00                       entry m_sinc_dinc
0580 9A00                       entry make_seg
0581 9A00                       entry map_vi
0582 9A00                       entry map_vp
0583 9A00                       entry map_vrn
0584 9A00                       entry merge_free
0585 9A00                       entry mm_deref
0586 9A00                       entry modesave
0587 9A00                       entry movetable
0588 9A00                       entry mybc
0589 9A00                       entry name_search
0590 9A00                       entry newline
0591 9A00                       entry newvidsv
0592 9A00                       entry null_call
0593 9A00                       entry null_flag
0594 9A00                       entry num
0595 9A00                       entry obj_list_tab
0596 9A00                       entry obj_type
0597 9A00                       entry os_add_queue
0598 9A00                       entry os_delete_queue
0599 9A00                       entry os_event
0600 9A00                       entry os_shutdown
0601 9A00                       entry out
0602 9A00                       entry out2
0603 9A00                       entry out80
0604 9A00                       entry page2sv
0605 9A00                       entry patch_vector
0606 9A00                       entry path_to_fst_id
0607 9A00                       entry prefices
0608 9A00                       entry prodos_index
0609 9A00                       entry char_index
0610 9A00                       entry prompt
0611 9A00                       entry queue_signal
0612 9A00                       entry release_record
0613 9A00                       entry release_v_ptrs
0614 9A00                       entry releasefcr
0615 9A00                       entry releasevcr
0616 9A00                       entry rename_record
0617 9A00                       entry renamefcr
0618 9A00                       entry renamevcr
0619 9A00                       entry replace80
0620 9A00                       entry res_block
0621 9A00                       entry reserve_id
0622 9A00                       entry reset_cache
0623 9A00                       entry restart_system
0624 9A00                       entry restore_screen
0625 9A00                       entry restore_vector
0626 9A00                       entry return_1
0627 9A00                       entry return_2
0628 9A00                       entry return_from_fst
0629 9A00                       entry return_from_lc
0630 9A00                       entry s_full_error
0631 9A00                       entry s_get_boot_pfx
0632 9A00                       entry s_get_sys_gbuf
0633 9A00                       entry s_mount_msg
0634 9A00                       entry parse_path
0635 9A00                       entry s_report_error
0636 9A00                       entry s_report_fatal
0637 9A00                       entry s_set_boot_pfx
0638 9A00                       entry s_signal
0639 9A00                       entry s_sys_death
0640 9A00                       entry save_screen
0641 9A00                       entry save_x
0642 9A00                       entry save_y
0643 9A00                       entry script_current
0644 9A00                       entry script_start
0645 9A00                       entry search_seg
0646 9A00                       entry seg_0_end
0647 9A00                       entry seg_1_end
0648 9A00                       entry seg_2_end
0649 9A00                       entry seg_3_end
0650 9A00                       entry seg_4_end
0651 9A00                       entry seg_tab_hand
0652 9A00                       entry select
0653 9A00                       entry select_seg
0654 9A00                       entry session_status
0655 9A00                       entry set_level
0656 9A00                       entry set_pfx
0657 9A00                       entry set_pfx_32
0658 9A00                       entry set_pfx_32_alt
0659 9A00                       entry set_prefix
0660 9A00                       entry set_ptr
0661 9A00                       entry set_sys_prefs
0662 9A00                       entry set_tab_ptr
0663 9A00                       entry set_type
0664 9A00                       entry setupformvx
0665 9A00                       entry signal_beat
0666 9A00                       entry signal_free
0667 9A00                       entry signal_head
0668 9A00                       entry signal_table
0669 9A00                       entry snuggles
0670 9A00                       entry stack_entry
0671 9A00                       entry stp2
0672 9A00                       entry str_to_int
0673 9A00                       entry sub_ptr_1
0674 9A00                       entry sub_ptr_2
0675 9A00                       entry sub_str_1
0676 9A00                       entry sub_str_2
0677 9A00                       entry sub_str_3
0678 9A00                       entry swapout
0679 9A00                       entry switchtab
0680 9A00                       entry system_level
0681 9A00                       entry temp_error
0682 9A00                       entry text_alert
0683 9A00                       entry textsv
0684 9A00                       entry type_3_alt
0685 9A00                       entry ul_hand
0686 9A00                       entry ul_mem
0687 9A00                       entry unbind_int
0688 9A00                       entry unbind_int2
0689 9A00                       entry unbind_int_vec
0690 9A00                       entry unfree
0691 9A00                       entry unlink_record
0692 9A00                       entry unlock_hand
0693 9A00                       entry unlockmem
0694 9A00                       entry user_int_entry
0695 9A00                       entry v_ptr1
0696 9A00                       entry v_ptr2
0697 9A00                       entry vcr_id_hand
0698 9A00                       entry vect_disp_base
0699 9A00                       entry vect_disp_hand
0700 9A00                       entry vrn_to_index
0701 9A00                       entry which_one
0702 9A00                       entry wreck_icr
0703 9A00                       entry xlate_count
0704 9A00                       entry xlate_path
0705 9A00                       entry xlate_path2
0706 9A00                       entry xlate_script
0707 9A00
0708 9A00                       entry dev_manager
0709 9A00                       entry init_path_vars
0710 9A00                       entry std_ref_num
0711 9A00                       entry get_std_ref_num
0712 9A00                       entry get_ref_num
0713 9A00                       entry shutdown_reboot
0714 9A00                       entry more
0715 9A00                       entry volume_parms
0716 9A00                       entry device_name
0717 9A00                       entry dev_name_length
0718 9A00                       entry insert_vol_name
0719 9A00                       entry path_script
0720 9A00                       entry case_mask2
0721 9A00                       entry fork_num
0722 9A00                       entry case_sense
0723 9A00                       entry displacement
0724 9A00                       entry fcr_index
0725 9A00                       entry found_count
0726 9A00                       entry install_int_vec
0727 9A00                       entry remove_int_vec
0728 9A00                       entry interrupt_patch
0729 9A00                       entry int_patch_1
0730 9A00                       entry int_patch_2
0731 9A00                       entry int_patch_3
0732 9A00                       entry patch_state
0733 9A00                       entry get_ref_info
0734 9A00                       entry vidtab
0735 9A00                       entry seg_tab_copy
0736 9A00                       entry do_all
0737 9A00                       entry gsos_lc_entry
0738 9A00                       entry dispatch_signal
0739 9A00                       entry disp_user_int
0740 9A00                       entry disp_common_int
0741 9A00                       entry do_volume_call
0742 9A00                       entry force_lock
0743 9A00                       entry force_unlock
0744 9A00                       entry ul_mem2
0745 9A00                       entry alt_rel_vcr
0746 9A00                       entry init_parsepath
0747 9A00                       entry grab_fixed_seg
0748 9A00                       entry init_spcl_list
0749 9A00                       entry play_script
0750 9A00                       entry do_alert_window
0751 9A00                       entry loader_rename
0752 9A00                       entry lock_vector
0753 9A00                       entry unlock_vector
0754 9A00                       entry seg_tab_last
0755 9A00
0756 9A00                       eject 
0757 9A00              *******************************************************************************
0758 9A00              *
0759 9A00              *   Includes
0760 9A00              *
0761 9A00              *******************************************************************************
0762 9A00
0763 9A00                       include 'common.equ.src'
0764 9A00                       include 'hw.equ.src'
0765 9A00                       include 'gsos.macros.src'
0766 9A00                       include 'driver.equ.src' 
0767 9A00
0768 9A00                       print pop
0769 9A00                       eject 
0770 9A00              *******************************************************************************
0771 9A00              *
0772 9A00              *   Equates
0773 9A00              *
0774 9A00              *******************************************************************************
0775 9A00
0776 9A00              ;===============================================================================
0777 9A00              ; Data for processor functions
0778 9A00              ;===============================================================================
0779 9A00
0780 9A00              m16      equ   $20                      ;mode setting value for 16-bit m
0781 9A00              x16      equ   $10                      ;mode setting value for 16-bit x
0782 9A00              mx16     equ   $30                      ;mode setting value for 16-bit m and x
0783 9A00              m8       equ   $20                      ;mode setting value for 8-bit m
0784 9A00              x8       equ   $10                      ;mode setting value for 8-bit x
0785 9A00              mx8      equ   $30                      ;mode setting value for 8-bit m and x
0786 9A00              n_flag   equ   $80                      ;n status flag
0787 9A00              v_flag   equ   $40                      ;v status flag
0788 9A00              m_flag   equ   $20                      ;m mode flag
0789 9A00              x_flag   equ   $10                      ;x mode flag
0790 9A00              b_flag   equ   $10                      ;b status flag
0791 9A00              d_flag   equ   $08                      ;d mode flag
0792 9A00              i_flag   equ   $04                      ;i mode flag
0793 9A00              z_flag   equ   $02                      ;z status flag
0794 9A00              c_flag   equ   $01                      ;c status flag
0795 9A00              e_flag   equ   $01                      ;e mode flag
0796 9A00              not_c_flag equ   $FFFE                  ;complement of c_flag
0797 9A00              not_z_flag equ   $FFFD                  ;complement of z_flag
0798 9A00              mx16_or_d_flag equ   $38                ;mask to turn off m, x, and d bits
0799 9A00
0800 9A00              ;===============================================================================
0801 9A00              ; Data in the GS/OS global space in bank $E1
0802 9A00              ;===============================================================================
0803 9A00
0804 9A00              active_flag equ   os_flag               ;GS/OS external active flag word
0805 9A00                                                      ;bit 15=0:  GS/OS inactive
0806 9A00                                                      ;bit 15=1:  GS/OS active
0807 9A00                                                      ;bits 14-0:  reserved
0808 9A00
0809 9A00              is_active equ   $8000                   ;value for GS/OS active (use ora)
0810 9A00              is_inactive equ   $7FFF                 ;value for GS/OS inactive (use and)
0811 9A00              ;shutdown_flag	equ	$E100B8	;flag to indicate gquit vs. shutdown
0812 9A00              ;do_gquit	equ	$0000	;indicate that a gquit is in progress
0813 9A00              ;do_shutdown	equ	$0001	;indicate that shutdown is in progress
0814 9A00
0815 9A00              sys_busy_flag equ   $e100ff             ;System busy flag (0=not busy).
0816 9A00
0817 9A00              ;===============================================================================
0818 9A00              ; Data used by the GS/OS shell system call processor.
0819 9A00              ;===============================================================================
0820 9A00
0821 9A00              is_inline equ   $0006                   ;value for inline type os call
0822 9A00              is_stack equ   $0000                    ;value for stack type os call
0823 9A00              is_native equ   $0000                   ;value for call from native mode
0824 9A00              is_emulation equ   $8000                ;value for call from emulation mode
0825 9A00              i_bit_mask equ   $0400                  ;mask to recover i bit from stacked P
0826 9A00              default_prefs equ   $8000
0827 9A00
0828 9A00              ;===============================================================================
0829 9A00              ; GS/OS system direct page equates
0830 9A00              ;===============================================================================
0831 9A00
0832 9A00              perm_work equ   span2+2                 ;direct page permanent work area
0833 9A00              user_stack equ   perm_work              ;pointer to base of user stack (4 bytes)
0834 9A00
0835 9A00              temp_work equ   $D4                     ;direct page temporary work area
0836 9A00              s_temp1  equ   temp_work
0837 9A00              s_temp2  equ   s_temp1+4
0838 9A00              s_temp3  equ   s_temp2+4
0839 9A00              s_temp4  equ   s_temp3+4
0840 9A00              s_temp5  equ   s_temp4+4
0841 9A00
0842 9A00              ;===============================================================================
0843 9A00              ; Aliases for direct page equates
0844 9A00              ;===============================================================================
0845 9A00
0846 9A00              ;
0847 9A00              ; Aliases used by SCM entry routines
0848 9A00              ;
0849 9A00              call_block equ   s_temp1                ;pointer to GS/OS call block
0850 9A00
0851 9A00              ;
0852 9A00              ; Aliases used by pathname translation routines.
0853 9A00              ;
0854 9A00              in_ptr   equ   s_temp1                  ;pointer to input string data structure
0855 9A00              in_curr  equ   s_temp2                  ;pointer to output string data structure
0856 9A00              in_end   equ   s_temp2+2                ;offset of current position in input
0857 9A00              out_ptr  equ   s_temp3                  ;offset one past end of input
0858 9A00              out_curr equ   s_temp4                  ;offset of current position in output
0859 9A00              out_end  equ   s_temp4+2                ;offset one past end of output
0860 9A00              control  equ   s_temp5                  ;upper case flag and separator char
0861 9A00              max_span equ   s_temp5+2                ;maximal span between separators in a
0862 9A00                                                      ;...pathname
0863 9A00
0864 9A00              ;===============================================================================
0865 9A00              ; Miscellaneous constants
0866 9A00              ;===============================================================================
0867 9A00
0868 9A00              sep      equ   $3A                      ;canonical separator character
0869 9A00              nul      equ   $00                      ;ASCII null (string terminator)
0870 9A00
0871 9A00              bit0     equ   $0001                    ;Value for bit 0.
0872 9A00              bit1     equ   $0002                    ;Value for bit 1.
0873 9A00              bit2     equ   $0004                    ;Value for bit 2.
0874 9A00              bit3     equ   $0008                    ;Value for bit 3.
0875 9A00              bit4     equ   $0010                    ;Value for bit 4.
0876 9A00              bit5     equ   $0020                    ;Value for bit 5.
0877 9A00              bit6     equ   $0040                    ;Value for bit 6.
0878 9A00              bit7     equ   $0080                    ;Value for bit 7.
0879 9A00              bit8     equ   $0100                    ;Value for bit 8.
0880 9A00              bit9     equ   $0200                    ;Value for bit 9.
0881 9A00              bitA     equ   $0400                    ;Value for bit A.
0882 9A00              bitB     equ   $0800                    ;Value for bit B.
0883 9A00              bitC     equ   $1000                    ;Value for bit C.
0884 9A00              bitD     equ   $2000                    ;Value for bit D.
0885 9A00              bitE     equ   $4000                    ;Value for bit E.
0886 9A00              bitF     equ   $8000                    ;Value for bit F.
0887 9A00
0888 9A00              ;===============================================================================
0889 9A00              ; Data for tool calls
0890 9A00              ;===============================================================================
0891 9A00
0892 9A00              inc_busy_flag equ   $E10064             ;address of inc_busy_flag call
0893 9A00              dec_busy_flag equ   $E10068             ;address of dec_busy_flag call
0894 9A00
0895 9A00
0896 9A00              ;===============================================================================
0897 9A00              ; FST Table Data Structures
0898 9A00              ;===============================================================================
0899 9A00
0900 9A00              max_fsts equ   16                       ;maximum number of FSTs allowed
0901 9A00
0902 9A00              ; offsets of fields within an FST Table entry
0903 9A00
0904 9A00              fst_hdr_ptr equ   0                     ;pointer to FST header
0905 9A00              app_entry equ   fst_hdr_ptr+4           ;address of FST's application entry pt
0906 9A00              sys_entry equ   app_entry+4             ;address of FST's system entry point
0907 9A00              id       equ   sys_entry+4              ;FST id value
0908 9A00              s_flags  equ   id+2                     ;flags
0909 9A00                                                      ;bit 15 =0, do not upper case pathnames
0910 9A00                                                      ; =1, force upper case in pathnames
0911 9A00                                                      ;bit 14 =0, the FST is a block FST
0912 9A00                                                      ; =1, the FST is a character FST
0913 9A00              entry_size equ   s_flags+2
0914 9A00              table_size equ   max_fsts*entry_size
0915 9A00              init_fst equ   $0002                    ;code to init FST call
0916 9A00              kill_fst equ   $0004                    ;code to shtdwn of FST
0917 9A00              kill_vcr equ   $0006                    ;code to free FST specific data from VCR
0918 9A00              flush_def equ   $0008                   ;code to flush deferred blks on a VCR
0919 9A00
0920 9A00              ;------------------------------------------
0921 9A00              ;
0922 9A00              ; Equates from procedure session_data
0923 9A00              ;
0924 9A00              ;------------------------------------------
0925 9A00
0926 9A00              session_on equ   $0001                  ;value for session in progress
0927 9A00              session_off equ   $0000                 ;value for no session in progress
0928 9A00
0929 9A00
0930 9A00              ;------------------------------------------
0931 9A00              ;
0932 9A00              ; Equates from procedure alert_data
0933 9A00              ;
0934 9A00              ;------------------------------------------
0935 9A00
0936 9A00              mount_msg_num1 equ   1                  ;Error number for mount message
0937 9A00              mount_msg_num2 equ   46                 ;Alternate error # for mount message
0938 9A00              right_arrow equ   $15
0939 9A00              left_arrow equ   $08
0940 9A00              up_arrow equ   $0B
0941 9A00              down_arrow equ   $0A
0942 9A00              return_key equ   $0D
0943 9A00              null0    equ   $00
0944 9A00              xbias    equ   1
0945 9A00              ybias    equ   2
0946 9A00              box_orig_x equ   0
0947 9A00              box_orig_y equ   6
0948 9A00              box_width equ   40
0949 9A00              box_height equ   13
0950 9A00              buttons  equ   3
0951 9A00              button_x equ   0                        ;button x position (column)
0952 9A00              button_y equ   button_x+1               ;button y position (row)
0953 9A00              button_len equ   button_y+1             ;number of characters in button label
0954 9A00              button_resp equ   button_len+1          ;response if button is pressed
0955 9A00              record_len equ   button_resp+1          ;length of this record
0956 9A00              num_buttons equ   1                     ;button number of button being processed
0957 9A00              default_button equ   num_buttons+2      ;button number of default button
0958 9A00              button_table equ   default_button+2     ;button characteristics table
0959 9A00              delim_char equ   button_table+(buttons*record_len)
0960 9A00              alert_ptr equ   delim_char+2            ;pointer to the alert string
0961 9A00              subst_ptr equ   alert_ptr+4             ;pointer to the substitution table
0962 9A00              temp     equ   subst_ptr+4              ;general temporary
0963 9A00              subst_str_ptr equ   temp+2              ;pointer to substitution string
0964 9A00              selected_button equ   subst_str_ptr+4   ;the selected button
0965 9A00              ch       equ   selected_button+2        ;cursor horizontal position
0966 9A00              cv       equ   ch+1                     ;cursor vertical position
0967 9A00              aptr     equ   cv+1                     ;general purpose pointer
0968 9A00              dp_size  equ   aptr+4-1                 ;size of direct page word space
0969 9A00              s_error  equ   51
0970 9A00              s_subst_ptr equ   47
0971 9A00              dp_save_area equ   $e0d000              ;save area for GS/OS direct page and one
0972 9A00
0973 9A00              ;
0974 9A00              ; Equates from procedure save_screen
0975 9A00              ;
0976 9A00              storage  equ   $E0D000
0977 9A00
0978 9A00
0979 9A00              ;----------------------------------------------------------------------------
0980 9A00              ;
0981 9A00              ; GIM Equates
0982 9A00              ;
0983 9A00              ;----------------------------------------------------------------------------
0984 9A00
0985 9A00
0986 9A00              ; Dynalist Constants
0987 9A00
0988 9A00              list_alc_flag equ   $8000               ;MSB indicates active entry in segtab
0989 9A00              list_min_size equ   4                   ;Minimum size (entries) of a list
0990 9A00              list_grow_inc equ   8                   ;Inc (entries) in which list is grown
0991 9A00              list_stump equ   4                      ;Size of proto-list
0992 9A00              list_size equ   0                       ;Location of size (bytes) in list memory
0993 9A00              list_freehead equ   2                   ;Location of free header in list memory
0994 9A00
0995 9A00
0996 9A00              ; Segment Allocation Constants
0997 9A00
0998 9A00              segment_size equ   $2000
0999 9A00              fwd_ovrhead equ   10                    ;Amount of overhead at the front of blk
1000 9A00              block_ovrhd equ   12                    ;Total # of bytes of overhead each block
1001 9A00              max_blk_size equ   segment_size-6       ;Segment size -free header -dummytags
1002 9A00              min_blk_size equ   block_ovrhd+4        ;4 bytes is smallest usable space
1003 9A00              bsize1   equ   $0000
1004 9A00              flink    equ   $0002                    ;Used for unallocated blocks
1005 9A00              blink    equ   $0004                    ;Used for unallocated blocks
1006 9A00              succ     equ   $0002                    ;Used for allocated records
1007 9A00              pred     equ   $0006                    ;Used for allocated records
1008 9A00
1009 9A00              seg_tab_stump equ   $0004               ;Table Size + free header
1010 9A00              seg_tab_free equ   $0002                ;Free header location in segment table
1011 9A00              init_block equ   $0004                  ;Begins after the free header & Dumtag
1012 9A00              dtag1_posn equ   $0002                  ;First dummy tag position
1013 9A00              dtag1_valu equ   $8000                  ;MSB set to indicate allocated block
1014 9A00              dtag2_posn equ   segment_size-2         ;Second dummy tab position
1015 9A00              dtag2_valu equ   dtag1_valu             ;Same as first tag
1016 9A00              size1_posn equ   init_block+bsize1      ;First size word (tag = unallocated)
1017 9A00              size2_posn equ   dtag2_posn-2           ;2nd size word just before dummy tag
1018 9A00              fwd_posn equ   init_block+flink         ;Forward Link position
1019 9A00              back_posn equ   init_block+blink        ;Backward link position
1020 9A00              head_valu equ   $FFFE                   ;Kluge to make back patch work okay
1021 9A00              free_posn equ   $0000                   ;Position in segment of free header
1022 9A00
1023 9A00              nullval  equ   $0000
1024 9A00
1025 9A00
1026 9A00              ; Object List Constants
1027 9A00
1028 9A00              num_obj_lists equ   2+25                ;Number of different types of objects
1029 9A00
1030 9A00              number_prefix equ   34                  ;Number of prefixes allowed (incl '*' & '@')
1031 9A00
1032 9A00
1033 9A00              ; List Offsets
1034 9A00
1035 9A00              vcr_list equ   $0000                    ;Head pointer for VCRs
1036 9A00              fcr_list equ   $0004                    ;Head pointer for FCRs
1037 9A00              icr_list equ   $0008                    ;Head pointers for ICRs
1038 9A00
1039 9A00              *
1040 9A00              * Miscellaneous Equates
1041 9A00              *
1042 9A00              dib_dev_char equ   $0008                ;Offset to device characteristics in dib.
1043 9A00              block_dev_mask equ   %0000000010000000  ;Block/Character device bit. 
1044 9A00              character_fst equ   $0009               ;ID for character fst.
1045 9A00              close_call_num equ   $0014              ;Call number for close call.
1046 9A00              flush_call_num equ   $0015              ;Call number for flush call.
1047 9A00
1048 9A00              d_rename_num equ   $0036                ;d_rename call num.
1049 9A00              d_calls_start equ   $002c               ;Start of device call #'s.
1050 9A00              d_calls_end equ   $0031                 ;End of device call #'s.
1051 9A00              d_calls_type equ   $000a                ;Call type for device calls.
1052 9A00
1053 9A00              set_user_level equ   $8000              ;User level OR mask.
1054 9A00
1055 9A00              cflag    equ   $01                      ;Processor Status mask
1056 9A00              vflag    equ   $40                      ;Processor Status mask
1057 9A00
1058 9A00              mm_id_tag equ   $3100                   ;Tag for misc tools getID call
1059 9A00              mm_normal_attr equ   $0008              ;No spcl mem.
1060 9A00              mm_fixed_attr equ   $4008               ;Fixed, no spcl mem.
1061 9A00
1062 9A00              icr_size equ   6                        ;Size of Interrupt Control Record
1063 9A00
1064 9A00              ; Error Codes
1065 9A00
1066 9A00              init_nomem_err equ   $0000
1067 9A00              fst_brs_err equ   $0000
1068 9A00              al_nomem_err equ   $0000
1069 9A00              cs_nomem_err equ   $0000
1070 9A00
1071 9A00
1072 9A00              ; GIM Zero Page Permanent Storage
1073 9A00
1074 9A00              seg_tab  equ   $004C                    ;4
1075 9A00              size     equ   seg_tab+4                ;2
1076 9A00
1077 9A00
1078 9A00              ; GIM Zero Page Temporaries
1079 9A00
1080 9A00              temporals equ   $00E8
1081 9A00
1082 9A00              ptr      equ   temporals                ;4
1083 9A00              m_temp   equ   ptr+4                    ;4
1084 9A00              seg      equ   m_temp+4                 ;4
1085 9A00              vp       equ   seg+4                    ;4
1086 9A00              vcr      equ   vp+4                     ;4
1087 9A00              hand     equ   vcr+4                    ;4
1088 9A00              pb_ptr   equ   hand                     ;4
1089 9A00
1090 9A00
1091 9A00              ;
1092 9A00              ; Signal equates
1093 9A00              ;
1094 9A00              sig_link equ   0                        ;offset of link field to next record
1095 9A00              sig_priority equ   2                    ;offset of priority field
1096 9A00              sig_hand_addr equ   4                   ;offset of signal handler address field
1097 9A00              sig_rec_size equ   8                    ;number of bytes in signal record
1098 9A00              sig_null_ptr equ   $8000                ;null pointer for signal queue
1099 9A00              num_signals equ   8                     ;maximum number of signals in queue
1100 9A00              disp_free equ   $0000                   ;values for dispatch_busy
1101 9A00              disp_busy equ   $8000
1102 9A00
1103 9A00              ;------------------------------------------
1104 9A00              ;
1105 9A00              ; Equates from procedure interrupt_data
1106 9A00              ;
1107 9A00              ;------------------------------------------
1108 9A00
1109 9A00              i_temp   equ   $F8                      ;temporary direct page offset
1110 9A00              user_int_vector equ   $0003FE           ;address of user interrupt vector
1111 9A00              o_table_length equ   list_size          ;offset of table length field
1112 9A00              o_free_list equ   list_freehead         ;offset of free entry list header
1113 9A00              o_first_entry equ   4                   ;offset of first table entry
1114 9A00              o_int_hand_addr equ   0                 ;offset of interrupt handler address
1115 9A00              o_vrn    equ   4                        ;offset of interrupt vector index (VI)
1116 9A00              num_vects equ   25
1117 9A00              vect_disp_len equ   num_vects*4
1118 9A00
1119 9A00
1120 9A00              ;------------------------------------------
1121 9A00              ;
1122 9A00              ; Equates from procedure m_move_equ
1123 9A00              ;
1124 9A00              ;------------------------------------------
1125 9A00
1126 9A00              source   equ   $16                      ; 4-byte source address
1127 9A00              dest     equ   $12                      ; 4-byte destination address
1128 9A00              count    equ   $0e                      ; 4-byte transfer count
1129 9A00              movecommand equ   $0c                   ; 2-byte command word
1130 9A00              returnmove equ   $09                    ; 3-byte return address
1131 9A00              tempcount equ   $07                     ; 2-byte temporary transfer count
1132 9A00              domove   equ   $03                      ; 4-byte mvn 0000 / rtl instructions
1133 9A00              stackused equ   $14                     ; number of bytes on stack used
1134 9A00
1135 9A00              *
1136 9A00              * Segment equates...
1137 9A00              *
1138 9A00
1139 9A00              header_length equ   $30
1140 9A00
1141 9A00              seg_0_start equ   $009a00               ;Segment start address.
1142 9A00              seg_0_max equ   $00a280                 ;Segment end address+1.
1143 9A00
1144 9A00              seg_1_start equ   $00b300               ;Segment start address.
1145 9A00              seg_1_max equ   globals_end             ;Segment end address+1.
1146 9A00
1147 9A00              seg_2_start equ   $00d000               ;Segment start address.
1148 9A00              seg_2_max equ   $010000                 ;Segment end address+1.
1149 9A00
1150 9A00              seg_3_start equ   $01fc00               ;Segment start address.
1151 9A00              seg_3_max equ   $01fd00                 ;Segment end address+1.
1152 9A00
1153 9A00              seg_4_start equ   $e1d980               ;Segment start address.
1154 9A00              seg_4_max equ   $e1e000                 ;Segment end address+1.
1155 9A00
1156 9A00                       gbla &segment_pc               ;Allocate a global counter.
1157 9A00
1158 9A00                       eject 
1159 9A00              *******************************************************************************
1160 9A00              *
1161 9A00              * Begin oscall segment: $009A00-00A280
1162 9A00              *
1163 9A00                       SEG   'oscall_seg'             ;Becomes scm_seg_0.
1164 9A00                       resetpc                        ;Reset pc.
1165 9A00              *
1166 9A00              *******************************************************************************
1167 9A00                       eject 
1168 9A00              ;===============================================================================
1169 9A00              ; GS/OS SYSTEM CALL MANAGER
1170 9A00              ;===============================================================================
1171 9A00              ; This module performs all general processing of GS/OS system calls from the
1172 9A00              ; point at which they are issued by an application to the point at which they
1173 9A00              ; are passed to other parts of the system, including other parts of the System
1174 9A00              ; Call Manager for further processing.
1175 9A00              ;===============================================================================
1176 9A00
1177 9A00                       eject 
1178 9A00              ;===============================================================================
1179 9A00              ; Main entry points for GS/OS system calls from application programs
1180 9A00              ;===============================================================================
1181 9A00              ;
1182 9A00              ; Created:      4/1/87
1183 9A00              ; Modified:     1/25/88  Moved IncBusyFlag call to just before DecBusyFlag
1184 9A00              ; Author:       JJ
1185 9A00              ;
1186 9A00              ; Entry points:
1187 9A00              ;   inline_entry  inline GS/OS call vectored from $E100A8
1188 9A00              ;   stack_entry   stack-based GS/OS call vectored from $E100B0
1189 9A00              ; Enter:
1190 9A00              ;   The caller must have made either an inline GS/OS call or a stack GS/OS call
1191 9A00              ;   An inline call has the following format:
1192 9A00              ;     jsl $E100A8
1193 9A00              ;     dc  i2'call_num'
1194 9A00              ;     dc  i4'parm_block'
1195 9A00              ;   A stack call has the following format:
1196 9A00              ;     push parm_block onto stack (4 bytes)
1197 9A00              ;     push call_num onto stack (2 bytes)
1198 9A00              ;     jsl $E100B0
1199 9A00              ; Input:
1200 9A00              ;   There are no requirements on register contents or processor mode.
1201 9A00              ; Output:
1202 9A00              ;   A    0=call successful, non-zero error code for unsuccessful call
1203 9A00              ;   X    unchanged
1204 9A00              ;   Y    unchanged
1205 9A00              ;   D    unchanged
1206 9A00              ;   S    call parameters (if any) and return address pulled off stack
1207 9A00              ;   P    see below
1208 9A00              ;   DB   unchanged
1209 9A00              ;   PB   unchanged
1210 9A00              ;   PC   address of location following GS/OS call block
1211 9A00              ;   n    undefined
1212 9A00              ;   v    undefined
1213 9A00              ;   m    unchanged if e=0 at time of call; otherwise, undefined
1214 9A00              ;   x    unchanged if e=0 at time of call; otherwise, undefined
1215 9A00              ;   b    undefined
1216 9A00              ;   d    unchanged
1217 9A00              ;   i    unchanged
1218 9A00              ;   z    0=call unsuccessful, 1=call successful
1219 9A00              ;   c    0=call successful, 1=call unsuccessful
1220 9A00              ;   e    unchanged
1221 9A00              ;===============================================================================
1222 9A00                       eject 
1223 9A00              ;===============================================================================
1224 9A00              ; Beginning of the GS/OS shell system call processor.  This module must be
1225 9A00              ; loaded below the language card since it must always be accessible.  Within
1226 9A00              ; this code segment, we use long absolute addressing to refer to certain data
1227 9A00              ; rather than setting up the DBR and using short absolute.  This is done
1228 9A00              ; deliberately because, at this point, we would have to save DBR on the user's
1229 9A00              ; stack before setting it.  Our goal is to minimize the amount of user stack
1230 9A00              ; space we use, so we will wait to save DBR and use faster addressing modes
1231 9A00              ; until we establish the GS/OS stack a bit later on.
1232 9A00              ;===============================================================================
1233 9A00
1234 9A00              oscall_module proc                      ;GS/OS system call handling
1235 9A00                       entry stack_entry
1236 9A00                       entry inline_entry
1237 9A00                       entry gbuf
1238 9A00                       entry return_from_lc
1239 9A00
1240 9A00                       longa on
1241 9A00                       longi on
1242 9A00
1243 9A00              gbuf      
1244 9A00 03 00 05 00           DS B:$400                      ;global buffer for FST use
1245 9E00
1246 9E00              inline_entry                            ;entry point for inline type call
1247 9E00 08                    php                            ;save P on user stack
1248 9E01 78                    sei                            ;disable interrupts temporarily
1249 9E02 18                    clc                            ;force cpu into native mode...
1250 9E03 FB                    xce                            ;... and save old mode in c
1251 9E04 08                    php                            ;save old value of e placed in c by xce
1252 9E05 C2 38                 rep   #mx16_or_d_flag          ;force 16-bit m and x and binary mode
1253 9E07 AF BE 00 E1           lda   >active_flag             ;is GS/OS active?
1254 9E0B 30 5D                 bmi   inl_actv_exit            ;yes, exit immediately
1255 9E0D A9 06 00              lda   #is_inline               ;flag indicating inline type call
1256 9E10 80 10                 bra   common_entry             ;go on to common processing
1257 9E12
1258 9E12              stack_entry                             ;entry point for stack type call
1259 9E12 08                    php                            ;save P on user stack
1260 9E13 78                    sei                            ;disable interrupts temporarily
1261 9E14 18                    clc                            ;force cpu into native mode...
1262 9E15 FB                    xce                            ;... and save old mode in c
1263 9E16 08                    php                            ;save old value of e placed in c by xce
1264 9E17 C2 38                 rep   #mx16_or_d_flag          ;force 16-bit m and x and binary mode
1265 9E19 AF BE 00 E1           lda   >active_flag             ;is GS/OS active?
1266 9E1D 30 55                 bmi   stk_actv_exit            ;yes, exit immediately
1267 9E1F A9 00 00              lda   #is_stack                ;flag indicating stack type call
1268 9E22
1269 9E22 8F 26 A0 00  common_entry sta   >entry_type          ;remember whether inline or stack call
1270 9E26
1271 9E26 6A                    ror   a                        ;get caller's processor mode saved ...
1272 9E27 29 00 80              and   #$8000                   ;... in c by xce above, and remember ...
1273 9E2A 8F 28 A0 00           sta   >entry_mode              ;... it in entry_mode
1274 9E2E
1275 9E2E 8A                    txa                            ;save x and y registers at this point
1276 9E2F 8F 2B A0 00           sta   >save_x                  ;... because inc_busy_flag is entitled
1277 9E33 98                    tya                            ;... to change them since it is almost
1278 9E34 8F 2D A0 00           sta   >save_y                  ;... a tool call
1279 9E38
1280 9E38              if 0 then  
1281 9E38                       jsl   inc_busy_flag            ;increment the system busy flag
1282 9E38              endif     
1283 9E38 AF BE 00 E1           lda   >active_flag             ;set active flag
1284 9E3C 09 00 80              ora   #is_active
1285 9E3F 8F BE 00 E1           sta   >active_flag
1286 9E43
1287 9E43 A3 01                 lda   1,s                      ;restore state of caller's i bit ...
1288 9E45 29 00 04              and   #i_bit_mask              ;... from first copy of P on stack
1289 9E48 D0 01                 bne   d_1                      ;interrupts were disabled, do nothing
1290 9E4A 58                    cli                            ;otherwise, reenable interrupts
1291 9E4B              d_1       
1292 9E4B E2 30                 sep   #mx8                     ;set up 8-bit m and x temporarily
1293 9E4D                       longa off
1294 9E4D                       longi off
1295 9E4D
1296 9E4D              ;	lda	>statereg	;save current language card state
1297 9E4D              ;	sta	>lc_state
1298 9E4D              ;	lda	>lcbank1	;select and write enable language ...
1299 9E4D              ;	lda	>lcbank1	;... card RAM bank 1 (really 0)
1300 9E4D              ;
1301 9E4D              ;	lda	#$00	;zero out power up byte
1302 9E4D              ;	sta	>$0003f4
1303 9E4D              *** added 2-Mar-93 DAL -- stuff a $4C at $00/BF00 so the Vulcan thinks we are in P8 (ick)
1304 9E4D 8B                    phb   
1305 9E4E F4 00 00              pea   $0000
1306 9E51 AB                    plb   
1307 9E52 AB                    plb                            ;set B to 0 for a sec
1308 9E53 AD 68 C0              lda   |statereg
1309 9E56 8D 2A A0              sta   |lc_state                ;save current language card state
1310 9E59 20 10 9F              jsr   lcbank1_twice
1311 9E5C 9C F4 03              stz   $03F4                    ;zero out the power-up byte
1312 9E5F A9 4C                 lda   #$4C
1313 9E61 8D 00 BF              sta   $BF00
1314 9E64 AB                    plb   
1315 9E65              *** end 2-Mar-93
1316 9E65
1317 9E65 C2 30                 rep   #mx16                    ;go back to 16-bit m and x
1318 9E67                       longa on
1319 9E67                       longi on
1320 9E67
1321 9E67 4C 5C D5              jmp   gsos_lc_entry            ;continue processing in language card
1322 9E6A                                                      ;return at label return_from_lc below
1323 9E6A
1324 9E6A              ;===============================================================================
1325 9E6A              ; GS/OS was active before the call, so exit with the gsos_active error since the
1326 9E6A              ; system is not reentrant.  For inline type call, no stack adjustment is
1327 9E6A              ; necessary; for stack type call, squeeze 6 bytes out of the stack before
1328 9E6A              ; continuing with normal exit.
1329 9E6A              ;===============================================================================
1330 9E6A
1331 9E6A              inl_actv_exit                           ;exit from inline call when GS/OS active
1332 9E6A 18                    clc                            ;update return address to point past ...
1333 9E6B A3 03                 lda   3,s                      ;... call_num and parm_block pointer
1334 9E6D 69 06 00              adc   #$0006                   ;since code can't cross bank boundary,
1335 9E70 83 03                 sta   3,s                      ;we only need to increment low word
1336 9E72 80 03                 bra   actv_exit
1337 9E74
1338 9E74              stk_actv_exit                           ;exit from stack call when GS/OS active
1339 9E74 20 EB 9E              jsr   stack_squeeze            ;squeeze call_num and parm_block pointer
1340 9E77
1341 9E77 A9 07 00     actv_exit lda   #gsos_active            ;error code for GS/OS already active
1342 9E7A 28                    plp                            ;restore caller's processor mode
1343 9E7B FB                    xce   
1344 9E7C 28                    plp                            ;restore caller's processor status
1345 9E7D C2 02                 rep   #z_flag                  ;clear z flag to indicate error
1346 9E7F 38                    sec                            ;set c flag to indicate error
1347 9E80 6B                    rtl                            ;return to caller
1348 9E81
1349 9E81              ;===============================================================================
1350 9E81              ; Return from portion of shell that executes in language card
1351 9E81              ;===============================================================================
1352 9E81
1353 9E81              return_from_lc                          ;must finish up processing outside ...
1354 9E81                                                      ;... language card because we have ...
1355 9E81                                                      ;... to restore user's memory state
1356 9E81                       Import io_flag
1357 9E81
1358 9E81 78                    sei                            ;temporarily disable interrupts while
1359 9E82                                                      ;manipulating active flag, etc.
1360 9E82
1361 9E82 AF BE 00 E1           lda   >active_flag             ;clear the GS/OS active flag
1362 9E86              *** optimized 2-Mar-93 DAL (saved 1 byte)
1363 9E86              ;;;	and	#is_inactive	;note: can't get here if GS/OS was ...
1364 9E86 0A                    asl   a
1365 9E87 4A                    lsr   a
1366 9E88              *** end 2-Mar-93
1367 9E88 8F BE 00 E1           sta   >active_flag             ;... active
1368 9E8C
1369 9E8C AF 26 A0 00           lda   >entry_type              ;determine whether inline or stack type
1370 9E90 F0 07                 beq   stack_exit               ;branch if stack type call
1371 9E92 18                    clc                            ;inline call-adjust return address by 6
1372 9E93 63 03                 adc   3,s                      ;note: entry_type = 6 in this case
1373 9E95 83 03                 sta   3,s
1374 9E97 80 03                 bra   common_exit
1375 9E99
1376 9E99 20 EB 9E     stack_exit jsr   stack_squeeze          ;squeeze out call_num and parm_block
1377 9E9C
1378 9E9C AF 2B A0 00  common_exit lda   >save_x               ;restore x register
1379 9EA0 AA                    tax   
1380 9EA1 AF 2D A0 00           lda   >save_y                  ;restore y register
1381 9EA5 A8                    tay   
1382 9EA6
1383 9EA6 AF 2F A0 00           lda   >temp_error              ;save global error code on stack since
1384 9EAA              *** added 2-Mar-93 DAL for convenience of debugging
1385 9EAA F0 04                 beq   @skip
1386 9EAC 8F 42 42 FC           sta   >$FC4242                 ;trigger logic analyzer
1387 9EB0              @skip     
1388 9EB0              *** end 2-Mar-93
1389 9EB0 48                    pha                            ;... it could be changed by a GS/OS
1390 9EB1                                                      ;... call initiated by dec_busy_flag
1391 9EB1
1392 9EB1 E2 20                 sep   #m8                      ;go to 8-bit m temporarily
1393 9EB3 AF 2A A0 00           lda   >lc_state                ;save caller's LC state on stack
1394 9EB7 48                    pha   
1395 9EB8 C2 20                 rep   #m16                     ;return to 16-bit m
1396 9EBA              ;
1397 9EBA              ; Restore interrupt state to user's interrupt state before calling
1398 9EBA              ; dec_busy_flag.  This minimizes the amount of time interrupts are explicitly
1399 9EBA              ; disabled by GS/OS.
1400 9EBA              ;
1401 9EBA A3 04                 lda   4,s                      ;get the two values of P from stack
1402 9EBC 29 00 04              and   #i_bit_mask              ;isolate state of user's i bit
1403 9EBF D0 01                 bne   d_2                      ;interrupts were disabled, do nothing
1404 9EC1 58                    cli                            ;otherwise, enable interrupts
1405 9EC2              d_2       
1406 9EC2 AF E0 B9 00           lda   >io_flag                 ;should we call dec_busy?
1407 9EC6 30 04                 bmi   @dont_call               ;no...
1408 9EC8 22 68 00 E1           jsl   dec_busy_flag            ;decrement system busy flag and ...
1409 9ECC                                                      ;potentially launch pending tasks.
1410 9ECC                                                      ;note: dec_busy_flag and all tasks ...
1411 9ECC                                                      ;... it launches are required to ...
1412 9ECC                                                      ;... save and restore all registers
1413 9ECC              @dont_call  
1414 9ECC              ;
1415 9ECC              ; Call the signal dispatcher.  Set c = state of i bit when application
1416 9ECC              ; called GS/OS.
1417 9ECC              ;
1418 9ECC AF E0 B9 00           lda   >io_flag                 ;should we call the signal dispatcher?
1419 9ED0 89 00 40              bit   #$4000
1420 9ED3 D0 08                 bne   @no_signals              ;no...
1421 9ED5
1422 9ED5 A3 05                 lda   5,s                      ;get application's P register
1423 9ED7 4A                    lsr   a                        ;shift i bit into c
1424 9ED8 4A                    lsr   a
1425 9ED9 4A                    lsr   a
1426 9EDA 20 2E ED              jsr   dispatch_signal          ;do it (see if we get lucky)
1427 9EDD
1428 9EDD              @no_signals  
1429 9EDD E2 20                 sep   #m8                      ;back to 8-bit m to get caller's
1430 9EDF 68                    pla                            ;...LC state and restore it
1431 9EE0 8F 68 C0 00           sta   >statereg
1432 9EE4 C2 20                 rep   #m16
1433 9EE6
1434 9EE6 68                    pla                            ;restore the error code to the a reg
1435 9EE7 28                    plp                            ;restore caller's processor mode
1436 9EE8 FB                    xce   
1437 9EE9 28                    plp                            ;restore caller's P register (c and ...
1438 9EEA                                                                 ;... z modified to reflect call status)
1439 9EEA
1440 9EEA 6B                    rtl                            ;return to caller
1441 9EEB
1442 9EEB              ;==============================================================================
1443 9EEB              ; stack_squeeze:  used when returning from a stack type GS/OS call to squeeze
1444 9EEB              ;                 the 4-byte param_blk_ptr and 2-byte call_number our of the
1445 9EEB              ;                 stack
1446 9EEB              ;
1447 9EEB              ; Enter:        jsr     stack_squeeze
1448 9EEB              ;
1449 9EEB              ; Input:        nvmxdizc
1450 9EEB              ;               ..000...
1451 9EEB              ;
1452 9EEB              ; Output:       A = trashed
1453 9EEB              ;===============================================================================
1454 9EEB
1455 9EEB A3 06        stack_squeeze lda   6,s                 ;copy 7 bytes to a location 6 bytes ...
1456 9EED 83 0C                 sta   12,s                     ;... higher in the stack
1457 9EEF A3 04                 lda   4,s
1458 9EF1 83 0A                 sta   10,s
1459 9EF3 A3 02                 lda   2,s
1460 9EF5 83 08                 sta   8,s
1461 9EF7 68                    pla                            ;tricky:  byte 2 is moved twice
1462 9EF8 83 05                 sta   5,s
1463 9EFA
1464 9EFA 68                    pla                            ;remove extra 4 bytes from stack
1465 9EFB 68                    pla   
1466 9EFC
1467 9EFC 60                    rts   
1468 9EFD
1469 9EFD                       end_proc 
1470 9EFD                       eject 
1471 9EFD              ;===============================================================================
1472 9EFD              ;===============================================================================
1473 9EFD              ; below_lc_int
1474 9EFD              ;
1475 9EFD              ; Interrupt system code that must exist in bank $00 below the langauge card (for
1476 9EFD              ; various reasons).
1477 9EFD              ;===============================================================================
1478 9EFD              ;===============================================================================
1479 9EFD
1480 9EFD              ;===============================================================================
1481 9EFD              ; user_int_entry
1482 9EFD              ;
1483 9EFD              ; Whenever the firmware interrupt handler fails to resolve an interrupt by
1484 9EFD              ; polling all of the standard interrupt vectors, it finally vectors control
1485 9EFD              ; through the user interrupt vector at $00/03FE, which GS/OS has patched to
1486 9EFD              ; point to this routine.  This routine sets up the proper processing
1487 9EFD              ; environment and hands control to the language card portion of the interrupt
1488 9EFD              ; manager.
1489 9EFD              ;
1490 9EFD              ; On entry to this routine,
1491 9EFD              ;               D = $0000
1492 9EFD              ;               DBR = $00
1493 9EFD              ;               e = emulation mode
1494 9EFD              ;               i = disabled
1495 9EFD              ;               speed = 1 MHz
1496 9EFD              ;===============================================================================
1497 9EFD
1498 9EFD              user_int_entry proc 
1499 9EFD
1500 9EFD 8B                    phb                            ;save DBR
1501 9EFE 0B                    phd                            ;save D
1502 9EFF
1503 9EFF AD 68 C0              lda   |statereg                ;save the value of the state register
1504 9F02 48                    pha                            ;...on the stack
1505 9F03
1506 9F03 20 10 9F              jsr   lcbank1_twice
1507 9F06
1508 9F06 20 8E EB              jsr   |disp_user_int           ;go to dispatch user interrupt
1509 9F09
1510 9F09 68                    pla                            ;restore state register value
1511 9F0A 8D 68 C0              sta   |statereg
1512 9F0D
1513 9F0D 2B                    pld                            ;restore D
1514 9F0E AB                    plb                            ;restore DBR
1515 9F0F
1516 9F0F 40                    rti                            ;return to interrupt firmware
1517 9F10
1518 9F10                       end_proc 
1519 9F10
1520 9F10              *** added 2-Mar-93 DAL
1521 9F10              ;===============================================================================
1522 9F10              ; lcbank1_twice -- enable LC bank 1 for read/write
1523 9F10              ;
1524 9F10              ; Do  lda |lcbank1  twice (save some bytes).
1525 9F10              ;===============================================================================
1526 9F10              lcbank1_twice proc 
1527 9F10 AD 8B C0              lda   |lcbank1
1528 9F13 AD 8B C0              lda   |lcbank1
1529 9F16 60                    rts   
1530 9F17                       endp 
1531 9F17              *** end 2-Mar-93 DAL
1532 9F17
1533 9F17                       eject 
1534 9F17              ;===============================================================================
1535 9F17              ; disp_stub_1
1536 9F17              ;
1537 9F17              ; Below language card code needed to hand control to a P16 interrupt handler and
1538 9F17              ; return from the interrupt handler.
1539 9F17              ;===============================================================================
1540 9F17
1541 9F17              disp_stub_1 proc 
1542 9F17                       entry int_disp_jump
1543 9F17
1544 9F17              int_disp_jump  
1545 9F17 22 00 00 00           jsl   >$000000                 ;JSL to the interrupt handler. Address
1546 9F1B                                                      ;...is modified by interrupt dispatcher
1547 9F1B E2 30                 sep   #mx8                     ;go to 8-bit mode to access soft switch
1548 9F1D 20 10 9F              jsr   lcbank1_twice
1549 9F20 C2 30                 rep   #mx16                    ;return to 16-bit m and x
1550 9F22
1551 9F22 4C C5 EB              jmp   return_1                 ;return to language card portion of code
1552 9F25
1553 9F25                       end_proc 
1554 9F25                       eject 
1555 9F25              ;===============================================================================
1556 9F25              ; common_disp_entry
1557 9F25              ;
1558 9F25              ; When a firmware interrupt vector has been patched by a class 1 alloc_interrupt
1559 9F25              ; call, the interrupt system is set up to hand control to a location in the
1560 9F25              ; Vector Dispatch Table (somewhere in memory), which then routes control to this
1561 9F25              ; routine.  This routine sets up the proper processing environment and hands
1562 9F25              ; control to the language card portion of the interrupt manager.
1563 9F25              ;
1564 9F25              ; On entry to this routine:
1565 9F25              ;               D = $0000 for other than irq.aptalk or irq.serial
1566 9F25              ;               D = undefined for irq.aptalk or irq.serial
1567 9F25              ;               DBR = $00 for other than irq.aptalk or irq.serial
1568 9F25              ;               DBR = undefined for irq.aptalk or irq.serial
1569 9F25              ;               e = native
1570 9F25              ;               m = 8-bit
1571 9F25              ;               x = 8-bit
1572 9F25              ;               i = disabled
1573 9F25              ;               speed = high
1574 9F25              ;===============================================================================
1575 9F25
1576 9F25              common_int_ent proc 
1577 9F25
1578 9F25 8B                    phb                            ;save DBR
1579 9F26 0B                    phd                            ;save D
1580 9F27
1581 9F27 4B                    phk                            ;set DBR=PBR=$00
1582 9F28 AB                    plb   
1583 9F29
1584 9F29 AD 68 C0              lda   |statereg                ;save value of statereg
1585 9F2C 48                    pha   
1586 9F2D 20 10 9F              jsr   lcbank1_twice
1587 9F30 20 E9 EB              jsr   disp_common_int          ;go to lc code to dispatch interrupt
1588 9F33
1589 9F33 68                    pla                            ;recover state register value
1590 9F34 8D 68 C0              sta   |statereg
1591 9F37
1592 9F37 2B                    pld                            ;restore D
1593 9F38 AB                    plb                            ;restore DBR
1594 9F39
1595 9F39 6B                    rtl                            ;return to interrupt firmware
1596 9F3A
1597 9F3A                       end_proc 
1598 9F3A                       eject 
1599 9F3A              ;===============================================================================
1600 9F3A              ; disp_stub_2
1601 9F3A              ;
1602 9F3A              ; Below language card code needed to hand control to a GS/OS interrupt handler
1603 9F3A              ; and return from the interrupt handler.
1604 9F3A              ;===============================================================================
1605 9F3A
1606 9F3A              disp_stub_2 proc 
1607 9F3A                       entry common_disp_jmp
1608 9F3A
1609 9F3A              common_disp_jmp  
1610 9F3A 22 00 00 00           jsl   >$000000                 ;JSL to the interrupt handler. Address
1611 9F3E                                                      ;...is modified by interrupt dispatcher
1612 9F3E E2 30                 sep   #mx8                     ;go to 8-bit mode to access soft switch
1613 9F40 20 10 9F              jsr   lcbank1_twice
1614 9F43 C2 30                 rep   #mx16                    ;return to 16-bit m and x
1615 9F45
1616 9F45 4C 2D EC              jmp   return_2                 ;return to language card portion of code
1617 9F48
1618 9F48                       end_proc 
1619 9F48                       eject 
1620 9F48              ;===============================================================================
1621 9F48              ; Signal Data
1622 9F48              ;
1623 9F48              ; NOTE: The equates in this record are commented out and are here for 
1624 9F48              ;       documentation purposes only.  The actual definitions are at the start
1625 9F48              ;       of this file.
1626 9F48              ;===============================================================================
1627 9F48
1628 9F48              signal_data proc 
1629 9F48
1630 9F48                       entry signal_head
1631 9F48                       entry signal_free
1632 9F48                       entry signal_table
1633 9F48                       entry dispatch_busy
1634 9F48                       entry interrupt_state
1635 9F48
1636 9F48              ;
1637 9F48              ; Offsets of fields in the signal records.
1638 9F48              ;
1639 9F48              ;sig_link	equ	0	;offset of link field to next record
1640 9F48              ;sig_priority	equ	2	;offset of priority field
1641 9F48              ;sig_hand_addr	equ	4	;offset of signal handler address field
1642 9F48
1643 9F48              ;sig_rec_size	equ	8	;number of bytes in signal record
1644 9F48              ;
1645 9F48              ; Signal queue data structures.
1646 9F48              ;
1647 9F48 00 80        signal_head DC W:0000                   ;signal queue header
1648 9F4A 00 00        signal_free DC W:0000                   ;free list header for signal records
1649 9F4C
1650 9F4C              ;sig_null_ptr	equ	$8000	;null pointer for signal queue
1651 9F4C              ;num_signals	equ	8	;maximum number of signals in queue
1652 9F4C
1653 9F4C 08 00 00 00  signal_table DS B:sig_rec_size*num_signals
1654 9F8C              ;
1655 9F8C              ; State variables for signal dispatching.
1656 9F8C              ;
1657 9F8C 00 00        dispatch_busy DC W:0000                 ;tells if dispatch_signal has been
1658 9F8E                                                      ;called but not yet returned
1659 9F8E              ;disp_free	equ	$0000	;values for dispatch_busy
1660 9F8E              ;disp_busy	equ	$8000
1661 9F8E
1662 9F8E 00 00        interrupt_state DC W:0000               ;flag used by dispatch_signal to keep
1663 9F90                                                      ;...track of interrupt state on entry
1664 9F90                                                      ;= $0000, interrupts enabled
1665 9F90                                                      ;= $8000, interrupts disabled.
1666 9F90
1667 9F90                       end_proc 
1668 9F90                       eject 
1669 9F90              ;==============================================================================
1670 9F90              ; Heartbeat task for dispatching signals.
1671 9F90              ;==============================================================================
1672 9F90
1673 9F90              signal_beat proc 
1674 9F90
1675 9F90              beat_count equ   60                     ;launch every 60 heartbeats
1676 9F90
1677 9F90 4C 01 E1 00           DC L:$00000000                 ;space for link
1678 9F94 1D 00        num_beats DC W:beat_count               ;heartbeat count betweeen launches
1679 9F96 5A A5                 DC W:$a55a                     ;signature
1680 9F98
1681 9F98 4B                    phk   
1682 9F99 AB                    plb   
1683 9F9A
1684 9F9A AD 68 C0              lda   |statereg
1685 9F9D 48                    pha   
1686 9F9E 20 10 9F              jsr   lcbank1_twice
1687 9FA1 C2 30                 rep   #mx16                    ;enter 16-bit m and x mode
1688 9FA3
1689 9FA3 AD 48 9F              lda   |signal_head             ;Anything in the signal queue?
1690 9FA6 30 09                 bmi   done                     ;Nope, so do nothing.
1691 9FA8 AF FF 00 E1           lda   >sys_busy_flag           ;Yes, is system busy?
1692 9FAC D0 03                 bne   done                     ;Yes, so do nothing.
1693 9FAE 20 61 B6              jsr   install_int_vec          ;Nope, so install our patch.
1694 9FB1
1695 9FB1 A9 3C 00     done     lda   #beat_count              ;restore the beat count
1696 9FB4 8F 94 9F 00           sta   >num_beats
1697 9FB8
1698 9FB8 E2 30                 sep   #mx16                    ;back to 8-bit m and x mode
1699 9FBA
1700 9FBA 68                    pla   
1701 9FBB 8D 68 C0              sta   |statereg
1702 9FBE
1703 9FBE 6B                    rtl   
1704 9FBF
1705 9FBF                       end_proc 
1706 9FBF                       eject 
1707 9FBF              *******************************************************************************
1708 9FBF              *
1709 9FBF              *        Name:  interrupt_patch
1710 9FBF              *
1711 9FBF              * Description:  Handles dispatching signals with interrupts ENABLED.  This code
1712 9FBF              *               CANNOT reside in the LC area since the LC ROM may be switched
1713 9FBF              *              in at interrupt time.
1714 9FBF              *
1715 9FBF              *      Author:  Bryan Atsatt
1716 9FBF              *     Created:  Feb 22, 1989
1717 9FBF              *    Modified:
1718 9FBF              *
1719 9FBF              *       Entry:  irq ONLY!  Don't call this code.
1720 9FBF              *
1721 9FBF              *       Input:  A = undefined
1722 9FBF              *               X = undefined
1723 9FBF              *               Y = undefined
1724 9FBF              *               P = nvmxdizc
1725 9FBF              *                   ..000...
1726 9FBF              *
1727 9FBF              *               int_patch_1             ;JMP original vector.
1728 9FBF              *               int_patch_2             ;JMP original vector.
1729 9FBF              *               int_patch_3             ;JMP original vector.
1730 9FBF              *
1731 9FBF              *      Output:  A = undefined
1732 9FBF              *               X = undefined
1733 9FBF              *               Y = undefined
1734 9FBF              *               P = nvmxdizc
1735 9FBF              *                   ..000..?
1736 9FBF              *
1737 9FBF              *        Exit:  rti
1738 9FBF              *
1739 9FBF              *        Uses:  Lots of stuff
1740 9FBF              *
1741 9FBF              * Copyright Apple Computer, Inc. 1989  All rights reserved.
1742 9FBF              *******************************************************************************
1743 9FBF
1744 9FBF              interrupt_patch proc 
1745 9FBF
1746 9FBF              bank_0_rti equ   $0000c072              ;Address of an RTI instruction
1747 9FBF                                                      ;in bank zero.  If this ever
1748 9FBF                                                      ;moves we're in trouble but
1749 9FBF                                                      ;Fern assures me it never will!
1750 9FBF                       entry int_patch_1
1751 9FBF                       entry int_patch_2
1752 9FBF                       entry int_patch_3
1753 9FBF              *
1754 9FBF              * This code will be called from the main interrupt vector.  Is this an IRQ?
1755 9FBF              * Exit to original vector if not...
1756 9FBF              *
1757 9FBF 70 0A                 bvs   int_patch_1              ;No, so jump to original vec.
1758 9FC1              *
1759 9FC1              * Yes.  Set native mode then check to see if we came in in emulation mode.  If
1760 9FC1              * we did, skip ahead to is_emulation...
1761 9FC1              *
1762 9FC1 18                    clc                            ;Set native mode.
1763 9FC2 FB                    xce   
1764 9FC3 08                    php                            ;Save mode.  Is emulation?
1765 9FC4 B0 09                 bcs   is_emul_mode             ;Yes, so skip ahead.
1766 9FC6              *
1767 9FC6              * We're in native mode so simulate an IRQ so that RTI will return at our
1768 9FC6              * return address after interrupt is handled, then jump off to the original
1769 9FC6              * vector...
1770 9FC6              *
1771 9FC6 4B                    phk                            ;Put our bank on stack.
1772 9FC7 F4 EB 9F              pea   our_return               ;Put our return adr on stack.
1773 9FCA 08                    php                            ;Put our status on stack.
1774 9FCB 5C 00 00 00  int_patch_1 jmp   >00000000             ;Jump to original vector.
1775 9FCF              *
1776 9FCF              * We're in emulation mode.  Go to 8 bit m and test to see if this is really
1777 9FCF              * a break instruction.  If so, branch down to is_break...
1778 9FCF              *
1779 9FCF E2 20        is_emul_mode sep   #m8                  ;Go to 8 bit m.
1780 9FD1                       longa off
1781 9FD1
1782 9FD1 48                    pha                            ;Save A.
1783 9FD2 A3 03                 lda   03,s                     ;Get original status.
1784 9FD4 29 10                 and   #b_flag                  ;Is break instruction?
1785 9FD6 D0 0C                 bne   is_break                 ;Yes, so skip ahead.
1786 9FD8              *
1787 9FD8              * Not a break so simulate an IRQ so that RTI will return at our return
1788 9FD8              * address after interrupt is handled, then jump off to the original
1789 9FD8              * vector...
1790 9FD8              *
1791 9FD8 68                    pla                            ;Pop off saved A.
1792 9FD9 28                    plp                            ;Restore status.
1793 9FDA 08                    php                            ;Put it back on stack.
1794 9FDB 4B                    phk                            ;Put our bank on stack.
1795 9FDC F4 EB 9F              pea   our_return               ;Put our return adr on stack.
1796 9FDF 08                    php                            ;Put our status on stack.
1797 9FE0 5C 00 00 00  int_patch_2 jmp   >00000000             ;Jump to original vector.
1798 9FE4              *
1799 9FE4              * It's an emulation mode break instruction so just restore the state and
1800 9FE4              * jump off to original vector...
1801 9FE4              *
1802 9FE4 68           is_break pla                            ;Pop off saved A.
1803 9FE5 28                    plp                            ;Recover status.
1804 9FE6 FB                    xce                            ;Restore emulation mode.
1805 9FE7 5C 00 00 00  int_patch_3 jmp   >00000000             ;Jump to original vector.
1806 9FEB              *
1807 9FEB              * When the interrupt handler does an RTI, we will get control back here.  Save
1808 9FEB              * the state of the system and set it up for our purposes...
1809 9FEB              *
1810 9FEB C2 30        our_return rep   #mx16                  ;Set 16 bit m and x.
1811 9FED                       longa on
1812 9FED                       longi on
1813 9FED
1814 9FED 48                    pha                            ;Save A.
1815 9FEE DA                    phx                            ;Save X.
1816 9FEF 5A                    phy                            ;Save Y.
1817 9FF0 8B                    phb                            ;Save B.
1818 9FF1
1819 9FF1 4B                    phk                            ;Set data bank = program bank.
1820 9FF2 AB                    plb   
1821 9FF3 D8                    cld                            ;Make sure we're not in dec.
1822 9FF4
1823 9FF4 E2 20                 sep   #m8                      ;Go to 8 bit m. 
1824 9FF6 AD 68 C0              lda   |statereg                ;Save statereg so can restore.
1825 9FF9 48                    pha   
1826 9FFA 20 10 9F              jsr   lcbank1_twice
1827 9FFD C2 20                 rep   #m8                      ;Back to 16 bit m.
1828 9FFF              *
1829 9FFF              * At this point, interrupts are GUARANTEED to be enabled since the only way
1830 9FFF              * to get here is from an IRQ and the RTI will restore the state.  Now we get
1831 9FFF              * to the point of all this work, which is to dispatch signals with interrupts
1832 9FFF              * enabled if there are any to dispatch AND the system is not busy.
1833 9FFF              *
1834 9FFF              * First we will remove this patch (interrupt_patch) from the main vector so we
1835 9FFF              * won't go thru this again until another signal gets queued up.  Should we do
1836 9FFF              * the dispatch?
1837 9FFF              *
1838 9FFF 20 95 B6              jsr   remove_int_vec           ;Remove our patch.
1839 A002 AD 48 9F              lda   |signal_head             ;Anything in the queue?
1840 A005 30 0A                 bmi   main_exit                ;Nope, so exit.
1841 A007 AF FF 00 E1           lda   >sys_busy_flag           ;Yes, is the system busy?
1842 A00B D0 04                 bne   main_exit                ;Yes, so exit.
1843 A00D              *
1844 A00D              * Yes, so go do it...
1845 A00D              *
1846 A00D 18                    clc                            ;Indicate interrupts enabled.
1847 A00E 20 2E ED              jsr   dispatch_signal          ;Go dispatch all signals.
1848 A011              *
1849 A011              * Alright, we're all done.  Restore the state of the system and RTI if we came
1850 A011              * in in native mode, else skip ahead to emulation_exit...
1851 A011              *
1852 A011 E2 20        main_exit sep   #m8                     ;Go to 8 bit m. 
1853 A013 68                    pla                            ;Restore state of LC.
1854 A014 8D 68 C0              sta   |statereg
1855 A017 C2 20                 rep   #m8                      ;Back to 16 bit m.
1856 A019 AB                    plb                            ;Restore B.
1857 A01A 7A                    ply                            ;Restore Y.
1858 A01B FA                    plx                            ;Restore X.
1859 A01C 68                    pla                            ;Restore A.
1860 A01D 28                    plp                            ;Restore original status.  Did
1861 A01E                                                      ; we come in from emulation?
1862 A01E B0 01                 bcs   emulation_exit           ;Yes, so skip ahead.
1863 A020 40                    rti                            ;No, so exit.
1864 A021              *
1865 A021              * We came in in emulation mode so we need to go back to that mode and then jump
1866 A021              * off to an RTI instruction that lives in bank zero...
1867 A021              *
1868 A021 FB           emulation_exit xce                      ;Go back to emulation mode.
1869 A022 5C 72 C0 00           jmp   >bank_0_rti              ;Go to bank zero RTI.
1870 A026
1871 A026                       end_proc 
1872 A026                       eject 
1873 A026              ;===============================================================================
1874 A026              ; Data used by the GS/OS shell system call processor.  This module must be in
1875 A026              ; the same bank as the GS/OS System Call Manager.
1876 A026              ;
1877 A026              ; NOTE: The equates in this record are commented out and are here for 
1878 A026              ;       documentation purposes only.  The actual definitions are at the start
1879 A026              ;       of this file.
1880 A026              ;===============================================================================
1881 A026
1882 A026              oscall_data proc export
1883 A026
1884 A026                       entry entry_type
1885 A026                       entry entry_mode
1886 A026                       entry lc_state
1887 A026                       entry save_x
1888 A026                       entry save_y
1889 A026                       entry temp_error
1890 A026                       entry seg_tab_copy
1891 A026
1892 A026
1893 A026 06 00        entry_type DC W:0000                    ;records inline vs. stack type call
1894 A028                                                      ;  =is_inline inline type call
1895 A028                                                      ;  =is_stack stack type call
1896 A028              ;is_inline	equ	$0006	;value for inline type os call
1897 A028              ;is_stack	equ	$0000	;value for stack type os call
1898 A028
1899 A028 00 00        entry_mode DC W:0000                    ;records whether cpu was in native or
1900 A02A                                                      ; emulation mode before GS/OS call
1901 A02A                                                      ;  =is_native native mode
1902 A02A                                                      ;  =is_emulation emulation mode
1903 A02A              ;is_native	equ	$0000	;value for call from native mode
1904 A02A              ;is_emulation	equ	$8000	;value for call from emulation mode
1905 A02A
1906 A02A 0C           lc_state DC B:00                        ;saved language card state
1907 A02B
1908 A02B 00 08        save_x   DC W:0000                      ;saved value of x register
1909 A02D 07 00        save_y   DC W:0000                      ;saved value of y register
1910 A02F
1911 A02F              ;i_bit_mask	equ	$0400	;mask to recover i bit from stacked P
1912 A02F
1913 A02F
1914 A02F 11 00        temp_error DC W:0000                    ;temporary storage for system error code
1915 A031
1916 A031              *
1917 A031              * The following long is a copy of seg_tab which is maintained for deref_int...
1918 A031              *
1919 A031 53 F3 4F 00  seg_tab_copy DC L:00000000              ;Copy of seg_tab.
1920 A035
1921 A035                       end_proc 
1922 A035                       eject 
1923 A035              ;===============================================================================
1924 A035              ; xlate_script
1925 A035              ;
1926 A035              ; Translate pathnames according to the script for the current call.
1927 A035              ;
1928 A035              ; Created:      1/27/88
1929 A035              ; Modified:     1/12/89
1930 A035              ; Author:       JJ
1931 A035              ;
1932 A035              ; Enter:        jsr     xlate_script
1933 A035              ;
1934 A035              ; Input:        script_start            offset of beginning of script
1935 A035              ;               fst_flags               pathname translation control flags
1936 A035              ;               P = nvmxdizc
1937 A035              ;                   ..000...
1938 A035              ;
1939 A035              ; Output:       performs pathname translation as directed by the script and
1940 A035              ;               fst_flags
1941 A035              ;
1942 A035              ;               A = if c=0, undefined; if c=1, error code
1943 A035              ;               X = trashed
1944 A035              ;               Y = trashed
1945 A035              ;               P = nvmxdizc
1946 A035              ;                   ..000..|
1947 A035              ;                          0=no error, 1=error
1948 A035              ;===============================================================================
1949 A035
1950 A035              xlate_script proc 
1951 A035
1952 A035              *
1953 A035              * Initialize pathname variables...
1954 A035              *
1955 A035 20 74 E2              jsr   init_path_vars           ;Initialize pathname variables.
1956 A038              ;
1957 A038              ; Execute the pathname translation operators in the script.
1958 A038              ;
1959 A038 AD A6 B9              lda   |script_start            ;reinitialize script address to start
1960 A03B 8D A8 B9              sta   |script_current
1961 A03E
1962 A03E 20 9B D6     do_script jsr   play_script             ;get script information in A and X
1963 A041 F0 16                 beq   end_of_script            ;zero indicates end of script
1964 A043 A8                    tay                            ;save script byte in Y
1965 A044 29 F0 00              and   #$00F0                   ;isolate 'opcode' of the script
1966 A047 C9 30 00              cmp   #$0030                   ;is it pathname pointer?
1967 A04A D0 F2                 bne   do_script                ;no, try next script code
1968 A04C
1969 A04C 98           is_pathptr tya                          ;recover script code
1970 A04D 29 0F 00              and   #$000F                   ;isolate offset to pathname to translate
1971 A050 20 21 DD              jsr   xlate_path               ;translate the pathname
1972 A053 EE AE B9              inc   |xlate_count             ;increment pathname translation count
1973 A056 90 E6                 bcc   do_script                ;continue with script if no error
1974 A058 60                    rts                            ;return if there is an error
1975 A059
1976 A059              end_of_script                           ; ;return without error
1977 A059 18                    clc   
1978 A05A 60                    rts   
1979 A05B
1980 A05B                       end_proc 
1981 A05B                       eject 
1982 A05B              ;===============================================================================
1983 A05B              ;
1984 A05B              ; move_info revision history
1985 A05B              ;
1986 A05B              ; the general move routine (m_sinc_dinc) algorithm in this program is based
1987 A05B              ;    on the one used by the memory manager.  it has been updated for gs/os
1988 A05B              ;    purposes and in hopes that new hardware will take over this functionality]
1989 A05B              ;    in the future.
1990 A05B              ;
1991 A05B              ; memory manager move routine is by rich williams in original iigs rom.
1992 A05B              ;    later modified for prodos16 by jim jatczynski.
1993 A05B              ;
1994 A05B              ; 1/04/88  fab  1st release as move_info routine by fern bachman jr.
1995 A05B              ; 1/18/88  fab  m_sdec_dcon / m_scon_ddec needed cpy #$ffff in loop to test for
1996 A05B              ;                       falling through an address into the next lower bank.
1997 A05B              ;               m_sinc_ddec / m_sdec_dinc fixed counter calculation in to
1998 A05B              ;                       include count+1 when doing 8 bit increment.
1999 A05B              ;               m_scon_dinc changed inc <dest to inc <dest+2 for correct dest
2000 A05B              ;                       bank increment
2001 A05B              ;               performance statistics table added
2002 A05B              ;
2003 A05B              ;===============================================================================
2004 A05B
2005 A05B              ;===============================================================================
2006 A05B              ;
2007 A05B              ; performance statistics table
2008 A05B              ;
2009 A05B              ;  #   subroutine       time/byte    time/$10000 bytes
2010 A05B              ;-------------------------------------------------------
2011 A05B              ;  0   m_scon_dcon       7.36 usec       485.8 msec
2012 A05B              ;  1   m_sinc_dcon       9.30 usec       615.6 msec
2013 A05B              ;  2   m_sdec_dcon      10.48 usec       691.9 msec
2014 A05B              ;  4   m_scon_dinc       9.30 usec       615.6 msec
2015 A05B              ;  5   m_sinc_dinc       2.78 usec       180.7 msec
2016 A05B              ;  6   m_sdec_dinc      18.20 usec      1209.0 msec
2017 A05B              ;  8   m_scon_ddec      10.48 usec       691.9 msec
2018 A05B              ;  9   m_sinc_ddec      18.20 usec      1209.0 msec
2019 A05B              ;  a   m_sdec_ddec       2.78 usec       180.8 msec
2020 A05B              ;
2021 A05B              ;===============================================================================
2022 A05B                       eject 
2023 A05B              ;===============================================================================
2024 A05B              ; move_info
2025 A05B              ;
2026 A05B              ; Moves a block of data from a source location to a destination location.
2027 A05B              ;
2028 A05B              ; Calling sequence:
2029 A05B              ;   1. Place machine in full native mode (e=0, m=0, x=0)
2030 A05B              ;
2031 A05B              ;   2. Push high order word of source pointer onto stack
2032 A05B              ;   3. Push low order word of source pointer
2033 A05B              ;   4. Push high order word of destination pointer
2034 A05B              ;   5. Push low order word of destination pointer
2035 A05B              ;   6. Push high order word of transfer count
2036 A05B              ;   7. Push low order word of transfer count
2037 A05B              ;
2038 A05B              ;   8. Push command byte
2039 A05B              ;       _______________________________________________
2040 A05B              ;      |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |
2041 A05B              ;      |15|14|13|12|11|10|09|08|07|06|05|04|03|02|01|00|
2042 A05B              ;      |__|__|__|__|__|__|__|__|__|__|__|__|__|__|__|__|
2043 A05B              ;
2044 A05B              ;       bits 15/14      = reserved
2045 A05B              ;       bits 13/12/11   = move mode
2046 A05B              ;                       = 000           =reserved
2047 A05B              ;                       = 001           =block move
2048 A05B              ;                       = 010-111       =reserved
2049 A05B              ;       bits 10/9/8/7   = reserved
2050 A05B              ;       bits 6/5/4      = reserved
2051 A05B              ;       bits 3/2        = destination incrementer
2052 A05B              ;                       = 00 (+0)       =constant destination
2053 A05B              ;                       = 01 (+1)       =increment destination by 1
2054 A05B              ;                       = 10 (-1)       =decrement destination by 1
2055 A05B              ;                       = 11            =reserved
2056 A05B              ;       bits 1/0        = source incrementer
2057 A05B              ;                       = 00 (+0)       =constant source
2058 A05B              ;                       = 01 (+1)       =increment source by 1
2059 A05B              ;                       = 10 (-1)       =decrement source by 1
2060 A05B              ;                       = 11            =reserved
2061 A05B              ;
2062 A05B              ;   9. jsl move_info
2063 A05B              ;
2064 A05B
2065 A05B                       eject 
2066 A05B              ;                 Stack on entry
2067 A05B              ;      _______________________________________
2068 A05B              ;     |                                       |
2069 A05B              ;     |-     high word of source pointer     -|
2070 A05B              ;     |_______________________________________|   s+$10
2071 A05B              ;     |                                       |
2072 A05B              ;     |-     low word of source pointer      -|
2073 A05B              ;     |_______________________________________|   s+$0e
2074 A05B              ;     |                                       |
2075 A05B              ;     |-  high word of destination pointer   -|
2076 A05B              ;     |_______________________________________|   s+$0c
2077 A05B              ;     |                                       |
2078 A05B              ;     |-  low word of destination pointer    -|
2079 A05B              ;     |_______________________________________|   s+$0a
2080 A05B              ;     |                                       |
2081 A05B              ;     |-     high word of transfer count     -|
2082 A05B              ;     |_______________________________________|   s+$08
2083 A05B              ;     |                                       |
2084 A05B              ;     |-     low word of transfer count      -|
2085 A05B              ;     |_______________________________________|   s+$06
2086 A05B              ;     |                                       |
2087 A05B              ;     |-            command word             -|
2088 A05B              ;     |_______________________________________|   s+$04
2089 A05B              ;     |                                       |
2090 A05B              ;     |-                                     -|
2091 A05B              ;     |             return address            |
2092 A05B              ;     |-                                     -|
2093 A05B              ;     |_______________________________________|   s+$01
2094 A05B              ;
2095 A05B              ;
2096 A05B              ; Outputs:      if no error then
2097 A05B              ;               a= $0000
2098 A05B              ;               c= 0
2099 A05B              ;               if error then
2100 A05B              ;               a= error code
2101 A05B              ;               c= 1
2102 A05B              ;               data bank and direct register are preserved
2103 A05B              ;               a= error code
2104 A05B              ;               x,y = scrambled
2105 A05B              ;
2106 A05B              ; Notes:        The high byte of source, dest, and Count must be zero
2107 A05B              ;               The source and destination blocks must not overlap
2108 A05B              ;               This routine executes self modifying code on the stack
2109 A05B              ;                       and therefore is romable and reentrant
2110 A05B              ;===============================================================================
2111 A05B
2112 A05B              m_move_equ proc 
2113 A05B
2114 A05B              ; zero page locations used on stack
2115 A05B
2116 A05B
2117 A05B                       end_proc 
2118 A05B
2119 A05B              gs_move_info proc 
2120 A05B                       entry m_movefinished
2121 A05B                       entry m_abortmove
2122 A05B
2123 A05B                       longa on
2124 A05B                       longi on
2125 A05B
2126 A05B 48                    pha                            ; push two bytes on stack for tempcount
2127 A05C
2128 A05C F4 00 6B              pea   $6b00                    ;push an rtl instruction onto stack
2129 A05F
2130 A05F              ; note the a place holder of $00 was left on the stack when the rtl instrucion
2131 A05F              ;  was placed on the stack.  that byte will become the high byte of the operand
2132 A05F              ;  for the mvn instruction about to be pushed onto the stack
2133 A05F
2134 A05F              ; now put an mvn xxxx instruction on the stack (operand is modified later)
2135 A05F
2136 A05F F4 54 00              pea   $0054                    ;mvn and low byte of mvn operand
2137 A062
2138 A062 0B                    phd                            ; save user's direct page pointer 'd'
2139 A063
2140 A063 3B                    tsc                            ; make direct page correspond to stack
2141 A064 5B                    tcd   
2142 A065
2143 A065              ; zero page is now on stack here
2144 A065
2145 A065              ; zero page after pha, phd, push of 'mvn xxxx, rtl' tsc and tcd
2146 A065              ;      _______________________________________
2147 A065              ;     |                                       |
2148 A065              ;     |-     high word of source pointer     -|
2149 A065              ;     |_______________________________________|   $18
2150 A065              ;     |                                       |
2151 A065              ;     |-     low word of source pointer      -|
2152 A065              ;     |_______________________________________|   $16
2153 A065              ;     |                                       |
2154 A065              ;     |-  high word of destination pointer   -|
2155 A065              ;     |_______________________________________|   $14
2156 A065              ;     |                                       |
2157 A065              ;     |-  low word of destination pointer    -|
2158 A065              ;     |_______________________________________|   $12
2159 A065              ;     |                                       |
2160 A065              ;     |-     high word of transfer count     -|
2161 A065              ;     |_______________________________________|   $10
2162 A065              ;     |                                       |
2163 A065              ;     |-     low word of transfer count      -|
2164 A065              ;     |_______________________________________|   $0e
2165 A065              ;     |                                       |
2166 A065              ;     |-            command word             -|
2167 A065              ;     |_______________________________________|   $0c
2168 A065              ;     |                                       |
2169 A065              ;     |-                                     -|
2170 A065              ;     |             return address            |
2171 A065              ;     |-                                     -|
2172 A065              ;     |_______________________________________|   $09
2173 A065              ;     |                                       |
2174 A065              ;     |-           temp count word           -|
2175 A065              ;     |_______________________________________|   $07
2176 A065              ;     |               rtl                     |
2177 A065              ;     |_______________________________________|   $06
2178 A065              ;     |                                       |
2179 A065              ;     |-                                     -|
2180 A065              ;     |  domove    mvn 0000   ;(modified code)|
2181 A065              ;     |-                                     -|
2182 A065              ;     |_______________________________________|   $03
2183 A065              ;     |                                       |
2184 A065              ;     |-          user's direct page         -|
2185 A065              ;     |_______________________________________|   $01
2186 A065
2187 A065
2188 A065              ; stack moves down when phb info, rtl's info, and rts are placed on stack
2189 A065              ;      _______________________________________
2190 A065              ;     |        user's data bank register      |
2191 A065              ;     |_______________________________________|
2192 A065              ;     |    rts back from jsr domvxonstack     |
2193 A065              ;     |-                                     -|
2194 A065              ;     |_______________________________________|
2195 A065              ;     |                                       |
2196 A065              ;     |-                                     -|
2197 A065              ;     | rtl which points to continuation addr |
2198 A065              ;     |-                                     -|
2199 A065              ;     |_______________________________________|
2200 A065              ;     |                                       |
2201 A065              ;     |-                                     -|
2202 A065              ;     |       rtl which points to domove      |
2203 A065              ;     |-                                     -|
2204 A065              ;     |_______________________________________|
2205 A065              ;
2206 A065
2207 A065 8B                    phb                            ; save dbr on stack (mvn trashes it)
2208 A066
2209 A066 A5 18                 lda   <source+2                ;is high byte of dest/src/count = 0 ??
2210 A068 05 14                 ora   <dest+2
2211 A06A 05 10                 ora   <count+2
2212 A06C 29 00 FF              and   #$ff00
2213 A06F D0 3D                 bne   m_abortmove              ;not = then a high byte <>=0 was found
2214 A071
2215 A071              ; if the number of bytes to move equals zero we are done before we started
2216 A071
2217 A071 A5 0E                 lda   <count
2218 A073 05 10                 ora   <count+2
2219 A075 F0 34                 beq   m_movefinished           ;finished before we started (ha! ha!)
2220 A077
2221 A077              ; to speed up the most common move routine we will check for it now and
2222 A077              ;    not let it go through the normal move dispatcher
2223 A077
2224 A077 A5 0C                 lda   <movecommand             ;test if valid or not
2225 A079 C9 05 08              cmp   #move_sinc_dinc          ;test for most common mode first
2226 A07C F0 4E                 beq   m_sinc_dinc              ;= then do it quickly
2227 A07E
2228 A07E              ; to speed up the second most common move routine we will check for it now and
2229 A07E              ;    not let it go through the normal move dispatcher
2230 A07E
2231 A07E C9 0A 08              cmp   #move_sdec_ddec          ;test for the 2nd most common mode first
2232 A081 D0 03                 bne   move_info4
2233 A083 4C EE A1              jmp   m_sdec_ddec              ;= then do it quickly
2234 A086
2235 A086              ; the next 'bit' instruction uses a mask to test for invalid commands and
2236 A086              ;   invalid options.  this mask (found in equates/common.equ) must change as
2237 A086              ;   other commands become valid.
2238 A086
2239 A086              move_info4  
2240 A086 89 F0 F7              bit   #movevaliditymask        ;reserved bits set?
2241 A089 D0 23                 bne   m_abortmove
2242 A08B
2243 A08B 89 00 08              bit   #moveblkcmd              ;if moveblkcmd bit isn't set then error
2244 A08E F0 1E                 beq   m_abortmove
2245 A090
2246 A090              ; if we fall to here then figure out which move to do
2247 A090
2248 A090 29 0F 00              and   #$000f                   ;upper 3 nibbles are not important
2249 A093 0A                    asl   a                        ;set up 'x' to get to rest of moves
2250 A094 AA                    tax   
2251 A095
2252 A095              ; most of the move routines need this function so all routines will incur the
2253 A095              ;   overhead.  this is better and shorter than making it a callable subroutine.
2254 A095
2255 A095              ; make count into 2's complement so we can increment to $00000000 instead of
2256 A095              ;   decrementing to $00000000 since it is faster to increment than decrement
2257 A095              ;   32 bits worth of data (no compares needed).
2258 A095
2259 A095 A5 0E                 lda   <count                   ;low word of count
2260 A097 49 FF FF              eor   #$ffff
2261 A09A A8                    tay                            ;save for later
2262 A09B A5 10                 lda   <count+2                 ;high word of count
2263 A09D 49 FF FF              eor   #$ffff                   ;'a'=high word and 'y'=low word now
2264 A0A0
2265 A0A0 C8                    iny                            ;make 2's complement now
2266 A0A1 D0 01                 bne   move_info8
2267 A0A3 1A                    inc   a
2268 A0A4
2269 A0A4              move_info8  
2270 A0A4 84 0E                 sty   <count                   ;leave on zero page
2271 A0A6 85 10                 sta   <count+2                 ;leave on zero page
2272 A0A8
2273 A0A8              ; warning - code that gets jumped to from here assumes count is in 'y'
2274 A0A8
2275 A0A8 7C 5B A2              jmp   (movetable,x)            ;off to routine
2276 A0AB
2277 A0AB              ; common exit routine is here. all errors and move routines finish up here.
2278 A0AB
2279 A0AB              m_movefinished                          ;	 ;no bytes left to move
2280 A0AB 18                    clc                            ;indicate no error encountered
2281 A0AC 90 01                 bcc   no_m_abortmove
2282 A0AE
2283 A0AE              m_abortmove  
2284 A0AE 38                    sec                            ;indicate an error was encountered
2285 A0AF
2286 A0AF              no_m_abortmove  
2287 A0AF C2 30                 rep   #$30                     ;must exit in full native mode
2288 A0B1
2289 A0B1 AB                    plb                            ; restore dbr
2290 A0B2
2291 A0B2 A5 09                 lda   <returnmove              ; move return address past parameters
2292 A0B4 85 17                 sta   <source+1
2293 A0B6 A5 0A                 lda   <returnmove+1            ; move return address past parameters
2294 A0B8 85 18                 sta   <source+2
2295 A0BA
2296 A0BA 2B                    pld                            ; restore user's direct register
2297 A0BB
2298 A0BB 3B                    tsc                            ; set s to proper value
2299 A0BC 08                    php                            ;save 'c' around addition
2300 A0BD 18                    clc   
2301 A0BE 69 14 00              adc   #stackused               ;number of bytes used on stack
2302 A0C1 28                    plp                            ;restore correct exit 'c'
2303 A0C2 1B                    tcs                            ;fix up stack
2304 A0C3
2305 A0C3              ; set 'a' correctly for exit based on 'c'
2306 A0C3
2307 A0C3 A9 00 00              lda   #$0000                   ;assume no errors
2308 A0C6 90 03                 bcc   cleanexit
2309 A0C8 A9 53 00              lda   #parm_range_err          ;it's an error if here
2310 A0CB
2311 A0CB              cleanexit  
2312 A0CB 6B                    rtl   
2313 A0CC
2314 A0CC                       end_proc 
2315 A0CC
2316 A0CC              m_sinc_dinc proc                        ;5 source incs - destination incs
2317 A0CC
2318 A0CC              ; move with incrementing source address and incrementing destination address
2319 A0CC              ; get ready to do the standard move
2320 A0CC
2321 A0CC 20 23 A2              jsr   setupformvx              ;set up for mvn/mvp
2322 A0CF 80 14                 bra   m_mdfirst
2323 A0D1
2324 A0D1              ; main move loop
2325 A0D1
2326 A0D1              m_mdmore  
2327 A0D1 85 10                 sta   <count+2                 ; more bytes to move
2328 A0D3 A5 04                 lda   <domove+1                ; a = srcdst banks
2329 A0D5 E0 01 00              cpx   #$0001                   ; bank cross? if x=0
2330 A0D8 B0 03                 bcs   m_mdxnot0
2331 A0DA 69 00 01              adc   #$0100                   ; add 1 to source bank
2332 A0DD
2333 A0DD              m_mdxnot0  
2334 A0DD C0 00 00              cpy   #$0000                   ; did destination cross bank?
2335 A0E0 D0 01                 bne   m_mdyis0
2336 A0E2 1A                    inc   a
2337 A0E3
2338 A0E3              m_mdyis0  
2339 A0E3 85 04                 sta   <domove+1
2340 A0E5
2341 A0E5              m_mdfirst  
2342 A0E5 8A                    txa                            ; if count > -x then bank cross
2343 A0E6 49 FF FF              eor   #$ffff
2344 A0E9 C5 07                 cmp   <tempcount
2345 A0EB B0 02                 bcs   m_mdxok
2346 A0ED 85 07                 sta   <tempcount               ; only move -x bytes
2347 A0EF
2348 A0EF              m_mdxok   
2349 A0EF 98                    tya                            ; will destination cross bank?
2350 A0F0 49 FF FF              eor   #$ffff
2351 A0F3 C5 07                 cmp   <tempcount
2352 A0F5 B0 02                 bcs   m_mdyok
2353 A0F7 85 07                 sta   <tempcount               ; only move -y bytes
2354 A0F9
2355 A0F9              m_mdyok   
2356 A0F9 20 3B A2              jsr   domvxonstack
2357 A0FC 10 D3                 bpl   m_mdmore
2358 A0FE
2359 A0FE 4C AB A0              jmp   m_movefinished
2360 A101
2361 A101                       end_proc 
2362 A101
2363 A101
2364 A101              m_scon_dcon proc                        ;0 source constant -destination constant
2365 A101
2366 A101              ;move with the source = constant address and the dest = constant address
2367 A101              ; 'y' contains count on entry
2368 A101
2369 A101 A6 10                 ldx   <count+2                 ;high byte of count in 'x'
2370 A103
2371 A103              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
2372 A103              ; we don't have to reset to 16 bit mode for 'a' here since m_movefinished does
2373 A103              ;    it for us.
2374 A103
2375 A103 E2 20                 sep   #$20                     ;make 'a' register 8 bits
2376 A105
2377 A105              m_scon_dconlp  
2378 A105 A7 16                 lda   [<source]                ;indirectly get source information
2379 A107 87 12                 sta   [<dest]                  ; and write it to the dest location
2380 A109
2381 A109              ; decrement counter by incrementing it to $00000000
2382 A109
2383 A109 C8                    iny                            ;increment move counter here
2384 A10A D0 F9                 bne   m_scon_dconlp            ;loop if didn't drop to zero yet
2385 A10C E8                    inx                            ;increment high byte of move counter
2386 A10D D0 F6                 bne   m_scon_dconlp            ;loop if done
2387 A10F
2388 A10F 4C AB A0              jmp   m_movefinished
2389 A112                       end_proc 
2390 A112
2391 A112
2392 A112              m_sinc_dcon proc                        ;1 source incs - destination constant
2393 A112
2394 A112              ;move with the source = incrementing address and the dest = constant address
2395 A112              ; 'y' contains count on entry
2396 A112
2397 A112 BB                    tyx                            ;low word of count is in 'y' on entry
2398 A113 A0 00 00              ldy   #$0000                   ;start at first source byte
2399 A116
2400 A116              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
2401 A116              ; we don't have to reset to 16 bit mode for 'a' here since m_movefinished does
2402 A116              ;    it for us.
2403 A116
2404 A116 E2 20                 sep   #$20                     ;must use 8 bit 'a' register
2405 A118
2406 A118              m_sinc_dconlp  
2407 A118 B7 16                 lda   [<source],y              ;get value to write
2408 A11A 87 12                 sta   [<dest]                  ; and write it to constant location
2409 A11C
2410 A11C              ; set up for new source address
2411 A11C
2412 A11C C8                    iny                            ;go to next source location
2413 A11D D0 02                 bne   m_sinc_dconlp2           ;loop if not = 0 yet
2414 A11F
2415 A11F              ; the next inc is an eight bit increment but that is ok since the high
2416 A11F              ;    byte of the high word is always zero to start anyway
2417 A11F
2418 A11F E6 18                 inc   <source+2                ;increment bank number
2419 A121
2420 A121              ; decrement counter by incrementing it to $00000000
2421 A121
2422 A121              m_sinc_dconlp2  
2423 A121 E8                    inx                            ;increment to 0
2424 A122 D0 F4                 bne   m_sinc_dconlp            ;loop if not done
2425 A124
2426 A124 E6 10                 inc   <count+2                 ;increment low byte of count word
2427 A126 D0 F0                 bne   m_sinc_dconlp            ;not = 0 then just continue
2428 A128 E6 11                 inc   <count+3                 ;increment upper byte of word too
2429 A12A D0 EC                 bne   m_sinc_dconlp            ;loop if not done
2430 A12C
2431 A12C 4C AB A0              jmp   m_movefinished           ;all done so exit
2432 A12F
2433 A12F                       end_proc 
2434 A12F
2435 A12F
2436 A12F              m_sdec_dcon proc                        ;2 source decs - destination constant
2437 A12F
2438 A12F              ;move with the source = decrementing address and the dest = constant address
2439 A12F              ; 'y' contains count on entry
2440 A12F
2441 A12F BB                    tyx                            ;low word of count
2442 A130 A4 16                 ldy   <source                  ;start at first source address
2443 A132 64 16                 stz   <source                  ;reset source pointer
2444 A134
2445 A134              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
2446 A134              ; we don't have to reset to 16 bit mode for 'a' here since m_movefinished does
2447 A134              ;    it for us.
2448 A134
2449 A134 E2 20                 sep   #$20                     ;must use 8 bit 'a' register
2450 A136
2451 A136              m_sdec_dconlp  
2452 A136 B7 16                 lda   [<source],y              ;get next data byte to move
2453 A138 87 12                 sta   [<dest]                  ;store at constant destination
2454 A13A
2455 A13A 88                    dey                            ;decrement to next source location
2456 A13B C0 FF FF              cpy   #$ffff                   ;dec through 0 then adjust source bank
2457 A13E D0 02                 bne   m_sdec_dconlp2           ;<>= then do some more
2458 A140
2459 A140              ; the next dec is an eight bit decrement but that is ok since the caller
2460 A140              ;   should never be decrementing in bank $00 and expect to go into bank $ff.
2461 A140
2462 A140 C6 18                 dec   <source+2                ;decrement source bank
2463 A142
2464 A142              ; decrement counter by incrementing it to $00000000
2465 A142
2466 A142              m_sdec_dconlp2  
2467 A142 E8                    inx                            ;adjust counter
2468 A143 D0 F1                 bne   m_sdec_dconlp            ;<>= then do some more
2469 A145
2470 A145 E6 10                 inc   <count+2                 ;increment low byte of count word
2471 A147 D0 ED                 bne   m_sdec_dconlp            ;not = 0 then just continue
2472 A149 E6 11                 inc   <count+3                 ;increment upper byte of word too
2473 A14B D0 E9                 bne   m_sdec_dconlp            ;<>= then do some more
2474 A14D
2475 A14D 4C AB A0              jmp   m_movefinished           ;done when we fall to here
2476 A150
2477 A150                       end_proc 
2478 A150
2479 A150              m_scon_dinc proc                        ;4 source constant - destination incs
2480 A150
2481 A150              ;move with the source = constant address and the dest = incrementing address
2482 A150              ; 'y' contains count on entry
2483 A150
2484 A150 BB                    tyx                            ;low word of count
2485 A151 A0 00 00              ldy   #$0000                   ;start at first destination byte
2486 A154
2487 A154              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
2488 A154              ; we don't have to reset to 16 bit mode for 'a' here since m_movefinished does
2489 A154              ;    it for us.
2490 A154
2491 A154 E2 20                 sep   #$20                     ;must use 8 bit 'a' register
2492 A156
2493 A156              m_scon_dinclp  
2494 A156 A7 16                 lda   [<source]                ;get constant value to write
2495 A158 97 12                 sta   [<dest],y                ; and write it to incrementing location
2496 A15A
2497 A15A              ; set up for new source address
2498 A15A
2499 A15A C8                    iny                            ;go to next source location
2500 A15B D0 02                 bne   m_scon_dinclp2           ;loop if not = 0 yet
2501 A15D
2502 A15D              ; the next inc is an eight bit increment but that is ok since the high
2503 A15D              ;    byte of the high word is always zero to start anyway
2504 A15D
2505 A15D E6 14                 inc   <dest+2                  ;increment bank number
2506 A15F
2507 A15F              ; decrement counter by incrementing it to $00000000
2508 A15F
2509 A15F              m_scon_dinclp2  
2510 A15F E8                    inx                            ;increment to 0
2511 A160 D0 F4                 bne   m_scon_dinclp            ;loop if not done
2512 A162
2513 A162 E6 10                 inc   <count+2                 ;increment low byte of count word
2514 A164 D0 F0                 bne   m_scon_dinclp            ;not = 0 then just continue
2515 A166 E6 11                 inc   <count+3                 ;increment upper byte of word too
2516 A168 D0 EC                 bne   m_scon_dinclp            ;loop if not done
2517 A16A
2518 A16A 4C AB A0              jmp   m_movefinished           ;all done so exit
2519 A16D
2520 A16D                       end_proc 
2521 A16D
2522 A16D              m_sdec_dinc proc                        ;6 source decs - destination incs
2523 A16D
2524 A16D              ;move with the source = decrementing address and the dest = incrementing address
2525 A16D
2526 A16D A4 16                 ldy   <source                  ;decrementing address
2527 A16F 64 16                 stz   <source                  ;reset source address
2528 A171 A2 00 00              ldx   #$0000                   ;incrementing address
2529 A174
2530 A174              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
2531 A174              ; we don't have to reset to 16 bit mode for 'a' here since m_movefinished does
2532 A174              ;    it for us.
2533 A174
2534 A174 E2 20                 sep   #$20                     ;must use 8 bit 'a' register
2535 A176
2536 A176              m_sdec_dinclp  
2537 A176 B7 16                 lda   [<source],y              ;get a byte to transfer
2538 A178 5A                    phy                            ;save 'y'
2539 A179 9B                    txy                            ;get destination address
2540 A17A 97 12                 sta   [<dest],y                ;save the byte
2541 A17C 7A                    ply                            ;restore source index
2542 A17D
2543 A17D 88                    dey                            ;next source index
2544 A17E C0 FF FF              cpy   #$ffff                   ;did we fall through 0 ??
2545 A181 D0 02                 bne   m_sdec_dinclp2           ;if not go here
2546 A183
2547 A183              ; the next dec is an eight bit decrement but that is ok since the caller
2548 A183              ;   should never be decrementing in bank $00 and expect to go into bank $ff.
2549 A183
2550 A183 C6 18                 dec   <source+2                ;back up a bank
2551 A185
2552 A185              m_sdec_dinclp2  
2553 A185 E8                    inx                            ;next destination index
2554 A186 D0 02                 bne   m_sdec_dinclp4           ;loop if no bank cross
2555 A188
2556 A188              ; the next inc is an eight bit increment but that is ok since the high
2557 A188              ;    byte of the high word is always zero to start anyway
2558 A188
2559 A188 E6 14                 inc   <dest+2                  ;next bank please
2560 A18A
2561 A18A              ; decrement counter by incrementing it to $00000000
2562 A18A
2563 A18A              m_sdec_dinclp4  
2564 A18A E6 0E                 inc   <count                   ;increment low word of count
2565 A18C D0 E8                 bne   m_sdec_dinclp
2566 A18E E6 0F                 inc   <count+1
2567 A190 D0 E4                 bne   m_sdec_dinclp
2568 A192 E6 10                 inc   <count+2                 ;increment upper word of count
2569 A194 D0 E0                 bne   m_sdec_dinclp
2570 A196 E6 11                 inc   <count+3
2571 A198 D0 DC                 bne   m_sdec_dinclp            ;loop if not done
2572 A19A
2573 A19A 4C AB A0              jmp   m_movefinished           ;exit via common routines
2574 A19D
2575 A19D                       end_proc 
2576 A19D
2577 A19D              m_scon_ddec proc                        ;8 source constant - destination decs
2578 A19D
2579 A19D              ;move with the source = constant address and the dest = decrementing address
2580 A19D              ; 'y' contains count on entry
2581 A19D
2582 A19D BB                    tyx                            ;low word of count
2583 A19E A4 12                 ldy   <dest                    ;start at first destination address
2584 A1A0 64 12                 stz   <dest                    ;reset destination pointer
2585 A1A2
2586 A1A2              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
2587 A1A2              ; we don't have to reset to 16 bit mode for 'a' here since m_movefinished does
2588 A1A2              ;    it for us.
2589 A1A2
2590 A1A2 E2 20                 sep   #$20                     ;must use 8 bit 'a' register
2591 A1A4
2592 A1A4              m_scon_ddeclp  
2593 A1A4 A7 16                 lda   [<source]                ;get constant source byte
2594 A1A6 97 12                 sta   [<dest],y                ;store at decrementing destination
2595 A1A8
2596 A1A8 88                    dey                            ;decrement to next source location
2597 A1A9 C0 FF FF              cpy   #$ffff                   ;dec through 0 then adjust dest bank
2598 A1AC D0 02                 bne   m_scon_ddeclp2           ;<>= then do some more
2599 A1AE
2600 A1AE              ; the next dec is an eight bit decrement but that is ok since the caller
2601 A1AE              ;   should never be decrementing in bank $00 and expect to go into bank $ff.
2602 A1AE
2603 A1AE C6 14                 dec   <dest+2                  ;decrement source bank
2604 A1B0
2605 A1B0              ; decrement counter by incrementing it to $00000000
2606 A1B0
2607 A1B0              m_scon_ddeclp2  
2608 A1B0 E8                    inx                            ;adjust counter
2609 A1B1 D0 F1                 bne   m_scon_ddeclp            ;<>= then do some more
2610 A1B3
2611 A1B3 E6 10                 inc   <count+2                 ;increment low byte of count word
2612 A1B5 D0 ED                 bne   m_scon_ddeclp            ;not = 0 then just continue
2613 A1B7 E6 11                 inc   <count+3                 ;increment upper byte of word too
2614 A1B9 D0 E9                 bne   m_scon_ddeclp            ;<>= then do some more
2615 A1BB
2616 A1BB 4C AB A0              jmp   m_movefinished           ;done when we fall to here
2617 A1BE
2618 A1BE                       end_proc 
2619 A1BE
2620 A1BE              m_sinc_ddec proc                        ;9 source incs - destination decs
2621 A1BE
2622 A1BE              ;move with the source = incrementing address and the dest = decrementing address
2623 A1BE
2624 A1BE A0 00 00              ldy   #$0000                   ;incrementing address
2625 A1C1 A6 12                 ldx   <dest                    ;decrementing address
2626 A1C3 64 12                 stz   <dest                    ;reset destination address
2627 A1C5
2628 A1C5              ; set the 'm' bit to 1 for 8 bit mode since we're moving one byte at a time.
2629 A1C5              ; we don't have to reset to 16 bit mode for 'a' here since m_movefinished does
2630 A1C5              ;    it for us.
2631 A1C5
2632 A1C5 E2 20                 sep   #$20                     ;must use 8 bit 'a' register
2633 A1C7
2634 A1C7              m_sinc_ddeclp  
2635 A1C7 B7 16                 lda   [<source],y              ;get a byte to transfer
2636 A1C9 5A                    phy                            ;save 'y'
2637 A1CA 9B                    txy                            ;get destination address
2638 A1CB 97 12                 sta   [<dest],y                ;save the byte
2639 A1CD 7A                    ply                            ;restore source index
2640 A1CE
2641 A1CE C8                    iny                            ;next source index
2642 A1CF D0 02                 bne   m_sinc_ddeclp2           ;if not go here
2643 A1D1
2644 A1D1              ; the next inc is an eight bit increment but that is ok since the high
2645 A1D1              ;    byte of the high word is always zero to start anyway
2646 A1D1
2647 A1D1 E6 18                 inc   <source+2                ;next bank
2648 A1D3
2649 A1D3              m_sinc_ddeclp2  
2650 A1D3 CA                    dex                            ;next destination index
2651 A1D4 E0 FF FF              cpx   #$ffff                   ;fallen through $0000 yet??
2652 A1D7 D0 02                 bne   m_sinc_ddeclp4           ;loop if no bank cross
2653 A1D9
2654 A1D9              ; the next dec is an eight bit decrement but that is ok since the caller
2655 A1D9              ;   should never be decrementing in bank $00 and expect to go into bank $ff.
2656 A1D9
2657 A1D9 C6 14                 dec   <dest+2                  ;next bank please
2658 A1DB
2659 A1DB              ; decrement counter by incrementing it to $00000000
2660 A1DB
2661 A1DB              m_sinc_ddeclp4  
2662 A1DB E6 0E                 inc   <count                   ;increment low word of count
2663 A1DD D0 E8                 bne   m_sinc_ddeclp
2664 A1DF E6 0F                 inc   <count+1
2665 A1E1 D0 E4                 bne   m_sinc_ddeclp
2666 A1E3 E6 10                 inc   <count+2                 ;increment upper word of count
2667 A1E5 D0 E0                 bne   m_sinc_ddeclp
2668 A1E7 E6 11                 inc   <count+3
2669 A1E9 D0 DC                 bne   m_sinc_ddeclp            ;loop if not done
2670 A1EB
2671 A1EB 4C AB A0              jmp   m_movefinished           ;exit via common routines
2672 A1EE
2673 A1EE                       end_proc 
2674 A1EE
2675 A1EE
2676 A1EE              m_sdec_ddec proc                        ;a source decs - destination decs
2677 A1EE
2678 A1EE              ; move with decrementing source address and decrementing destination address
2679 A1EE
2680 A1EE              ; set the move instuction in zero page to mvp
2681 A1EE
2682 A1EE A9 44 00              lda   #$0044                   ;mvp instruction
2683 A1F1 85 03                 sta   <domove                  ;upper byte doesn't matter it's modified
2684 A1F3
2685 A1F3 20 23 A2              jsr   setupformvx              ;set up for mvn/mvp
2686 A1F6 80 15                 bra   ddm_mdfirst
2687 A1F8
2688 A1F8              ; main move loop
2689 A1F8
2690 A1F8              ddm_mdmore  
2691 A1F8 85 10                 sta   <count+2                 ; more bytes to move
2692 A1FA A5 04                 lda   <domove+1                ; 'a' = srcdst banks
2693 A1FC E0 FF FF              cpx   #$ffff                   ; bank cross? if x=0
2694 A1FF D0 04                 bne   ddm_mdxnot0
2695 A201 38                    sec   
2696 A202 E9 00 01              sbc   #$0100                   ; subtract 1 to source bank
2697 A205
2698 A205              ddm_mdxnot0  
2699 A205 C0 FF FF              cpy   #$ffff                   ; did destination cross bank?
2700 A208 D0 01                 bne   ddm_mdyis0
2701 A20A 3A                    dec   a
2702 A20B
2703 A20B              ddm_mdyis0  
2704 A20B 85 04                 sta   <domove+1
2705 A20D
2706 A20D              ddm_mdfirst  
2707 A20D 8A                    txa                            ; if count > source then bank cross
2708 A20E C5 07                 cmp   <tempcount
2709 A210 B0 02                 bcs   ddm_mdxok
2710 A212 85 07                 sta   <tempcount               ; only move source bytes
2711 A214
2712 A214              ddm_mdxok  
2713 A214 98                    tya                            ; will destination cross bank?
2714 A215 C5 07                 cmp   <tempcount
2715 A217 B0 02                 bcs   ddm_mdyok
2716 A219 85 07                 sta   <tempcount               ; only move dest bytes
2717 A21B
2718 A21B              ddm_mdyok  
2719 A21B 20 3B A2              jsr   domvxonstack
2720 A21E 10 D8                 bpl   ddm_mdmore
2721 A220
2722 A220 4C AB A0              jmp   m_movefinished           ;exit via common routines
2723 A223
2724 A223                       end_proc 
2725 A223
2726 A223
2727 A223              setupformvx proc 
2728 A223
2729 A223              ; set up the self modifying code to contain destination
2730 A223              ; and source in operand of mvn/mvp instruction constructed on stack.
2731 A223
2732 A223 A5 18                 lda   <source+2                ;get source bank
2733 A225 EB                    xba   
2734 A226 05 14                 ora   <dest+2                  ;or in destination bank
2735 A228 85 04                 sta   <domove+1                ;put bank into mvn/mvp instruction
2736 A22A
2737 A22A              ; decrement count because it contains actual transfer count whereas
2738 A22A              ; remainder of routine assumes it contains transfer count - 1
2739 A22A
2740 A22A A5 0E                 lda   <count
2741 A22C D0 02                 bne   m_ara1
2742 A22E C6 10                 dec   <count+2
2743 A230              m_ara1    
2744 A230 C6 0E                 dec   <count
2745 A232
2746 A232              ; a move instuction is already on zero page at this point in the code
2747 A232
2748 A232              ; initialize registers and tempcount for mvn/mvp on stack
2749 A232
2750 A232 A6 16                 ldx   <source                  ; X = low word of source
2751 A234 A4 12                 ldy   <dest                    ; Y = low word of dest
2752 A236 A5 0E                 lda   <count
2753 A238 85 07                 sta   <tempcount
2754 A23A 60                    rts   
2755 A23B
2756 A23B                       end_proc 
2757 A23B
2758 A23B
2759 A23B              domvxonstack proc 
2760 A23B                       entry m_contdomove
2761 A23B
2762 A23B
2763 A23B              ; set up the address to rtl to which does the mvn on stack
2764 A23B              ; this is the equivalent of a self modifying jmp absolute long instruction.
2765 A23B
2766 A23B 4B                    phk                            ;push rtl return on stack
2767 A23C F4 4B A2              pea   m_contdomove-1           ;push rtl return address-1 on stack
2768 A23F
2769 A23F F4 00 00              pea   $0000                    ;we'll leave high byte $00 on stack
2770 A242 AB                    plb                            ; for setting correct execution bank.
2771 A243 3B                    tsc                            ;where are we now?
2772 A244 18                    clc   
2773 A245 69 09 00              adc   #$0009                   ;where are we going?
2774 A248                                                      ;+2 around user's direct page on stack
2775 A248                                                      ;+1 around user's data bank on stack
2776 A248                                                      ;+3 around m_contdomove rtl info on stack
2777 A248                                                      ;+2 around rts from jsr domvxonstack
2778 A248                                                      ;+1 around execution bank just put on stk
2779 A248 48                    pha                            ;full rtl info on stack
2780 A249
2781 A249 A5 07                 lda   <tempcount               ; get the number of bytes to move
2782 A24B 6B                    rtl                            ;execute on stack in case we're in rom
2783 A24C
2784 A24C              m_contdomove                            ;		;return here after mvn
2785 A24C A5 0E                 lda   <count                   ; count = count - bytes moved
2786 A24E 18                    clc                            ; actual bytes moved 1 more than count
2787 A24F E5 07                 sbc   <tempcount
2788 A251 85 0E                 sta   <count
2789 A253 85 07                 sta   <tempcount
2790 A255 A5 10                 lda   <count+2
2791 A257 E9 00 00              sbc   #$0000
2792 A25A 60                    rts   
2793 A25B
2794 A25B                       end_proc 
2795 A25B
2796 A25B
2797 A25B              movetable proc 
2798 A25B 01 A1                 DC W:m_scon_dcon               ;0 source constant -destination constanty
2799 A25D 12 A1                 DC W:m_sinc_dcon               ;1 source incs - destination constant
2800 A25F 2F A1                 DC W:m_sdec_dcon               ;2 source decs - destination constant
2801 A261 AE A0                 DC W:m_abortmove               ;3 illegal move sequence requested
2802 A263 50 A1                 DC W:m_scon_dinc               ;4 source constant - destination incs
2803 A265 AE A0                 DC W:m_abortmove               ;5 src/dest incs should never get here
2804 A267 6D A1                 DC W:m_sdec_dinc               ;6 source decs - destination incs
2805 A269 AE A0                 DC W:m_abortmove               ;7 illegal move sequence requested
2806 A26B 9D A1                 DC W:m_scon_ddec               ;8 source constant - destination decs
2807 A26D BE A1                 DC W:m_sinc_ddec               ;9 source incs - destination decs
2808 A26F AE A0                 DC W:m_abortmove               ;a src/dest decs should never get here
2809 A271 AE A0                 DC W:m_abortmove               ;b illegal move sequence requested
2810 A273 AE A0                 DC W:m_abortmove               ;c illegal move sequence requested
2811 A275 AE A0                 DC W:m_abortmove               ;d illegal move sequence requested
2812 A277 AE A0                 DC W:m_abortmove               ;e illegal move sequence requested
2813 A279 AE A0                 DC W:m_abortmove               ;f illegal move sequence requested
2814 A27B
2815 A27B                       end_proc 
2816 A27B                       eject 
2817 A27B              *******************************************************************************
2818 A27B              *
2819 A27B              * End oscall segment: $009A00-00A280
2820 A27B              *
2821 A27B              *******************************************************************************
